/************************************************************************************************/
/* Stata User File for H70 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H70.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H70.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H70.DO                                               */
/* The program below will output the Stata dataset H70.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL02 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID02 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-36
  byte   FCSZ1231 37-38
  byte   FCRP1231 39-40
  str    RULETR31 41-42
  str    RULETR42 43-44
  str    RULETR53 45-46
  str    RULETR02 47-48
  byte   RUSIZE31 49-50
  byte   RUSIZE42 51-52
  byte   RUSIZE53 53-54
  byte   RUSIZE02 55-56
  byte   RUCLAS31 57-58
  byte   RUCLAS42 59-60
  byte   RUCLAS53 61-62
  byte   RUCLAS02 63-63
  byte   FAMSZE31 64-65
  byte   FAMSZE42 66-67
  byte   FAMSZE53 68-69
  byte   FAMSZE02 70-71
  byte   FMRS1231 72-73
  byte   FAMS1231 74-75
  byte   FAMSZEYR 76-77
  byte   FAMRFPYR 78-79
  byte   REGION31 80-81
  byte   REGION42 82-83
  byte   REGION53 84-85
  byte   REGION02 86-87
  byte   MSA31 88-89
  byte   MSA42 90-91
  byte   MSA53 92-93
  byte   MSA02 94-95
  int    REFPRS31 96-98
  int    REFPRS42 99-101
  int    REFPRS53 102-104
  int    REFPRS02 105-107
  byte   RESP31 108-108
  byte   RESP42 109-109
  byte   RESP53 110-110
  byte   RESP02 111-111
  byte   PROXY31 112-113
  byte   PROXY42 114-115
  byte   PROXY53 116-117
  byte   PROXY02 118-118
  byte   INTVLANG 119-120
  byte   BEGRFD31 121-122
  byte   BEGRFM31 123-124
  int    BEGRFY31 125-128
  byte   ENDRFD31 129-130
  byte   ENDRFM31 131-132
  int    ENDRFY31 133-136
  byte   BEGRFD42 137-138
  byte   BEGRFM42 139-140
  int    BEGRFY42 141-144
  byte   ENDRFD42 145-146
  byte   ENDRFM42 147-148
  int    ENDRFY42 149-152
  byte   BEGRFD53 153-154
  byte   BEGRFM53 155-156
  int    BEGRFY53 157-160
  byte   ENDRFD53 161-162
  byte   ENDRFM53 163-164
  int    ENDRFY53 165-168
  byte   ENDRFD02 169-170
  byte   ENDRFM02 171-172
  int    ENDRFY02 173-176
  byte   KEYNESS 177-177
  byte   INSCOP31 178-178
  byte   INSCOP42 179-179
  byte   INSCOP53 180-180
  byte   INSCOP02 181-181
  byte   INSC1231 182-182
  byte   INSCOPE 183-183
  byte   ELGRND31 184-184
  byte   ELGRND42 185-185
  byte   ELGRND53 186-186
  byte   ELGRND02 187-187
  byte   PSTATS31 188-189
  byte   PSTATS42 190-191
  byte   PSTATS53 192-193
  str    RURSLT31 194-195
  str    RURSLT42 196-197
  str    RURSLT53 198-199
  byte   AGE31X 200-201
  byte   AGE42X 202-203
  byte   AGE53X 204-205
  byte   AGE02X 206-207
  byte   DOBMM 208-209
  int    DOBYY 210-213
  byte   SEX 214-214
  byte   RACEX 215-215
  byte   RACEAX 216-216
  byte   RACEBX 217-217
  byte   RACEWX 218-218
  byte   RACETHNX 219-219
  byte   HISPANX 220-220
  byte   HISPCAT 221-222
  byte   MARRY31X 223-224
  byte   MARRY42X 225-226
  byte   MARRY53X 227-228
  byte   MARRY02X 229-230
  int    SPOUID31 231-233
  int    SPOUID42 234-236
  int    SPOUID53 237-239
  int    SPOUID02 240-242
  byte   SPOUIN31 243-244
  byte   SPOUIN42 245-246
  byte   SPOUIN53 247-248
  byte   SPOUIN02 249-250
  byte   EDUCYEAR 251-252
  byte   HIDEGYR 253-254
  byte   FTSTU31X 255-256
  byte   FTSTU42X 257-258
  byte   FTSTU53X 259-260
  byte   FTSTU02X 261-262
  byte   ACTDTY31 263-264
  byte   ACTDTY42 265-266
  byte   ACTDTY53 267-268
  byte   DIDSERVE 269-270
  byte   VETVIET 271-272
  byte   VETKOR 273-274
  byte   VETWW 275-276
  byte   VETGULF 277-278
  byte   VETOTH 279-280
  byte   RFREL31X 281-282
  byte   RFREL42X 283-284
  byte   RFREL53X 285-286
  byte   RFREL02X 287-288
  int    MOPID31X 289-291
  int    MOPID42X 292-294
  int    MOPID53X 295-297
  int    DAPID31X 298-300
  int    DAPID42X 301-303
  int    DAPID53X 304-306
  byte   SSIDIS02 307-308
  byte   AFDC02 309-310
  byte   FILEDR02 311-312
  byte   WILFIL02 313-314
  byte   FLSTAT02 315-316
  byte   FILER02 317-318
  byte   JTINRU02 319-320
  int    JNTPID02 321-323
  byte   CLMDEP02 324-325
  byte   DEPDNT02 326-327
  byte   DPINRU02 328-329
  byte   DPOTSD02 330-331
  byte   TAXFRM02 332-333
  byte   DEDUCT02 334-335
  double TOTDED02 336-344
  byte   CLMHIP02 345-346
  byte   EICRDT02 347-348
  byte   FOODST02 349-350
  byte   FOODMN02 351-352
  double FOODCT02 353-358
  double FOODVL02 359-364
  long   TTLP02X 365-370
  byte   POVCAT02 371-371
  long   WAGEP02X 372-377
  byte   WAGIMP02 378-378
  long   BUSNP02X 379-385
  byte   BUSIMP02 386-386
  long   UNEMP02X 387-391
  byte   UNEIMP02 392-392
  long   WCMPP02X 393-397
  byte   WCPIMP02 398-398
  long   INTRP02X 399-403
  byte   INTIMP02 404-404
  long   DIVDP02X 405-409
  byte   DIVIMP02 410-410
  long   SALEP02X 411-416
  byte   SALIMP02 417-417
  long   PENSP02X 418-422
  byte   PENIMP02 423-423
  long   SSECP02X 424-428
  byte   SSCIMP02 429-429
  long   TRSTP02X 430-435
  byte   TRTIMP02 436-436
  long   VETSP02X 437-441
  byte   VETIMP02 442-442
  long   IRASP02X 443-447
  byte   IRAIMP02 448-448
  long   REFDP02X 449-453
  byte   REFIMP02 454-454
  long   ALIMP02X 455-459
  byte   ALIIMP02 460-460
  long   CHLDP02X 461-465
  byte   CHLIMP02 466-466
  long   CASHP02X 467-471
  byte   CSHIMP02 472-472
  long   SSIP02X 473-477
  byte   SSIIMP02 478-478
  int    PUBP02X 479-482
  byte   PUBIMP02 483-483
  long   OTHRP02X 484-488
  byte   OTHIMP02 489-489
  byte   EMPST31 490-491
  byte   EMPST42 492-493
  byte   EMPST53 494-495
  byte   RNDFLG31 496-497
  byte   MORJOB31 498-499
  byte   MORJOB42 500-501
  byte   MORJOB53 502-503
  byte   EVRWRK 504-505
  double HRWG31X 506-511
  double HRWG42X 512-517
  double HRWG53X 518-523
  byte   HRWGIM31 524-524
  byte   HRWGIM42 525-525
  byte   HRWGIM53 526-526
  byte   HRHOW31 527-528
  byte   HRHOW42 529-530
  byte   HRHOW53 531-532
  int    HOUR31 533-535
  int    HOUR42 536-538
  int    HOUR53 539-541
  byte   TEMPJB31 542-543
  byte   TEMPJB42 544-545
  byte   TEMPJB53 546-547
  byte   SSNLJB31 548-549
  byte   SSNLJB42 550-551
  byte   SSNLJB53 552-553
  byte   SELFCM31 554-555
  byte   SELFCM42 556-557
  byte   SELFCM53 558-559
  byte   INDCAT31 560-561
  byte   INDCAT42 562-563
  byte   INDCAT53 564-565
  int    NUMEMP31 566-568
  int    NUMEMP42 569-571
  int    NUMEMP53 572-574
  byte   MORE31 575-576
  byte   MORE42 577-578
  byte   MORE53 579-580
  byte   UNION31 581-582
  byte   UNION42 583-584
  byte   UNION53 585-586
  byte   NWK31 587-588
  byte   NWK42 589-590
  byte   NWK53 591-592
  byte   CHGJ3142 593-594
  byte   CHGJ4253 595-596
  byte   YCHJ3142 597-598
  byte   YCHJ4253 599-600
  byte   STJBMM31 601-602
  byte   STJBDD31 603-604
  int    STJBYY31 605-608
  byte   STJBMM42 609-610
  byte   STJBDD42 611-612
  int    STJBYY42 613-616
  byte   STJBMM53 617-618
  byte   STJBDD53 619-620
  int    STJBYY53 621-624
  byte   EVRETIRE 625-626
  byte   OCCCAT31 627-628
  byte   OCCCAT42 629-630
  byte   OCCCAT53 631-632
  byte   PAYVAC31 633-634
  byte   PAYVAC42 635-636
  byte   PAYVAC53 637-638
  byte   SICPAY31 639-640
  byte   SICPAY42 641-642
  byte   SICPAY53 643-644
  byte   PAYDR31 645-646
  byte   PAYDR42 647-648
  byte   PAYDR53 649-650
  byte   RETPLN31 651-652
  byte   RETPLN42 653-654
  byte   RETPLN53 655-656
  byte   BSNTY31 657-658
  byte   BSNTY42 659-660
  byte   BSNTY53 661-662
  byte   JOBORG31 663-664
  byte   JOBORG42 665-666
  byte   JOBORG53 667-668
  byte   HELD31X 669-670
  byte   HELD42X 671-672
  byte   HELD53X 673-674
  byte   OFFER31X 675-676
  byte   OFFER42X 677-678
  byte   OFFER53X 679-680
  byte   OFREMP31 681-682
  byte   OFREMP42 683-684
  byte   OFREMP53 685-686
  byte   YNOINS31 687-688
  byte   YNOINS42 689-690
  byte   YNOINS53 691-692
  byte   DISVW31X 693-694
  byte   DISVW42X 695-696
  byte   DISVW53X 697-698
  byte   CHOIC31 699-700
  byte   CHOIC42 701-702
  byte   CHOIC53 703-704
  byte   TRIJA02X 705-706
  byte   TRIFE02X 707-708
  byte   TRIMA02X 709-710
  byte   TRIAP02X 711-712
  byte   TRIMY02X 713-714
  byte   TRIJU02X 715-716
  byte   TRIJL02X 717-718
  byte   TRIAU02X 719-720
  byte   TRISE02X 721-722
  byte   TRIOC02X 723-724
  byte   TRINO02X 725-726
  byte   TRIDE02X 727-728
  byte   MCRJA02 729-730
  byte   MCRFE02 731-732
  byte   MCRMA02 733-734
  byte   MCRAP02 735-736
  byte   MCRMY02 737-738
  byte   MCRJU02 739-740
  byte   MCRJL02 741-742
  byte   MCRAU02 743-744
  byte   MCRSE02 745-746
  byte   MCROC02 747-748
  byte   MCRNO02 749-750
  byte   MCRDE02 751-752
  byte   MCRJA02X 753-754
  byte   MCRFE02X 755-756
  byte   MCRMA02X 757-758
  byte   MCRAP02X 759-760
  byte   MCRMY02X 761-762
  byte   MCRJU02X 763-764
  byte   MCRJL02X 765-766
  byte   MCRAU02X 767-768
  byte   MCRSE02X 769-770
  byte   MCROC02X 771-772
  byte   MCRNO02X 773-774
  byte   MCRDE02X 775-776
  byte   MCDJA02 777-778
  byte   MCDFE02 779-780
  byte   MCDMA02 781-782
  byte   MCDAP02 783-784
  byte   MCDMY02 785-786
  byte   MCDJU02 787-788
  byte   MCDJL02 789-790
  byte   MCDAU02 791-792
  byte   MCDSE02 793-794
  byte   MCDOC02 795-796
  byte   MCDNO02 797-798
  byte   MCDDE02 799-800
  byte   MCDJA02X 801-802
  byte   MCDFE02X 803-804
  byte   MCDMA02X 805-806
  byte   MCDAP02X 807-808
  byte   MCDMY02X 809-810
  byte   MCDJU02X 811-812
  byte   MCDJL02X 813-814
  byte   MCDAU02X 815-816
  byte   MCDSE02X 817-818
  byte   MCDOC02X 819-820
  byte   MCDNO02X 821-822
  byte   MCDDE02X 823-824
  byte   OPAJA02 825-826
  byte   OPAFE02 827-828
  byte   OPAMA02 829-830
  byte   OPAAP02 831-832
  byte   OPAMY02 833-834
  byte   OPAJU02 835-836
  byte   OPAJL02 837-838
  byte   OPAAU02 839-840
  byte   OPASE02 841-842
  byte   OPAOC02 843-844
  byte   OPANO02 845-846
  byte   OPADE02 847-848
  byte   OPBJA02 849-850
  byte   OPBFE02 851-852
  byte   OPBMA02 853-854
  byte   OPBAP02 855-856
  byte   OPBMY02 857-858
  byte   OPBJU02 859-860
  byte   OPBJL02 861-862
  byte   OPBAU02 863-864
  byte   OPBSE02 865-866
  byte   OPBOC02 867-868
  byte   OPBNO02 869-870
  byte   OPBDE02 871-872
  byte   STAJA02 873-874
  byte   STAFE02 875-876
  byte   STAMA02 877-878
  byte   STAAP02 879-880
  byte   STAMY02 881-882
  byte   STAJU02 883-884
  byte   STAJL02 885-886
  byte   STAAU02 887-888
  byte   STASE02 889-890
  byte   STAOC02 891-892
  byte   STANO02 893-894
  byte   STADE02 895-896
  byte   PUBJA02X 897-898
  byte   PUBFE02X 899-900
  byte   PUBMA02X 901-902
  byte   PUBAP02X 903-904
  byte   PUBMY02X 905-906
  byte   PUBJU02X 907-908
  byte   PUBJL02X 909-910
  byte   PUBAU02X 911-912
  byte   PUBSE02X 913-914
  byte   PUBOC02X 915-916
  byte   PUBNO02X 917-918
  byte   PUBDE02X 919-920
  byte   PEGJA02 921-922
  byte   PEGFE02 923-924
  byte   PEGMA02 925-926
  byte   PEGAP02 927-928
  byte   PEGMY02 929-930
  byte   PEGJU02 931-932
  byte   PEGJL02 933-934
  byte   PEGAU02 935-936
  byte   PEGSE02 937-938
  byte   PEGOC02 939-940
  byte   PEGNO02 941-942
  byte   PEGDE02 943-944
  byte   PDKJA02 945-946
  byte   PDKFE02 947-948
  byte   PDKMA02 949-950
  byte   PDKAP02 951-952
  byte   PDKMY02 953-954
  byte   PDKJU02 955-956
  byte   PDKJL02 957-958
  byte   PDKAU02 959-960
  byte   PDKSE02 961-962
  byte   PDKOC02 963-964
  byte   PDKNO02 965-966
  byte   PDKDE02 967-968
  byte   PNGJA02 969-970
  byte   PNGFE02 971-972
  byte   PNGMA02 973-974
  byte   PNGAP02 975-976
  byte   PNGMY02 977-978
  byte   PNGJU02 979-980
  byte   PNGJL02 981-982
  byte   PNGAU02 983-984
  byte   PNGSE02 985-986
  byte   PNGOC02 987-988
  byte   PNGNO02 989-990
  byte   PNGDE02 991-992
  byte   POGJA02 993-994
  byte   POGFE02 995-996
  byte   POGMA02 997-998
  byte   POGAP02 999-1000
  byte   POGMY02 1001-1002
  byte   POGJU02 1003-1004
  byte   POGJL02 1005-1006
  byte   POGAU02 1007-1008
  byte   POGSE02 1009-1010
  byte   POGOC02 1011-1012
  byte   POGNO02 1013-1014
  byte   POGDE02 1015-1016
  byte   PRSJA02 1017-1018
  byte   PRSFE02 1019-1020
  byte   PRSMA02 1021-1022
  byte   PRSAP02 1023-1024
  byte   PRSMY02 1025-1026
  byte   PRSJU02 1027-1028
  byte   PRSJL02 1029-1030
  byte   PRSAU02 1031-1032
  byte   PRSSE02 1033-1034
  byte   PRSOC02 1035-1036
  byte   PRSNO02 1037-1038
  byte   PRSDE02 1039-1040
  byte   POUJA02 1041-1042
  byte   POUFE02 1043-1044
  byte   POUMA02 1045-1046
  byte   POUAP02 1047-1048
  byte   POUMY02 1049-1050
  byte   POUJU02 1051-1052
  byte   POUJL02 1053-1054
  byte   POUAU02 1055-1056
  byte   POUSE02 1057-1058
  byte   POUOC02 1059-1060
  byte   POUNO02 1061-1062
  byte   POUDE02 1063-1064
  byte   PRIJA02 1065-1066
  byte   PRIFE02 1067-1068
  byte   PRIMA02 1069-1070
  byte   PRIAP02 1071-1072
  byte   PRIMY02 1073-1074
  byte   PRIJU02 1075-1076
  byte   PRIJL02 1077-1078
  byte   PRIAU02 1079-1080
  byte   PRISE02 1081-1082
  byte   PRIOC02 1083-1084
  byte   PRINO02 1085-1086
  byte   PRIDE02 1087-1088
  byte   HPEJA02 1089-1090
  byte   HPEFE02 1091-1092
  byte   HPEMA02 1093-1094
  byte   HPEAP02 1095-1096
  byte   HPEMY02 1097-1098
  byte   HPEJU02 1099-1100
  byte   HPEJL02 1101-1102
  byte   HPEAU02 1103-1104
  byte   HPESE02 1105-1106
  byte   HPEOC02 1107-1108
  byte   HPENO02 1109-1110
  byte   HPEDE02 1111-1112
  byte   HPDJA02 1113-1114
  byte   HPDFE02 1115-1116
  byte   HPDMA02 1117-1118
  byte   HPDAP02 1119-1120
  byte   HPDMY02 1121-1122
  byte   HPDJU02 1123-1124
  byte   HPDJL02 1125-1126
  byte   HPDAU02 1127-1128
  byte   HPDSE02 1129-1130
  byte   HPDOC02 1131-1132
  byte   HPDNO02 1133-1134
  byte   HPDDE02 1135-1136
  byte   HPNJA02 1137-1138
  byte   HPNFE02 1139-1140
  byte   HPNMA02 1141-1142
  byte   HPNAP02 1143-1144
  byte   HPNMY02 1145-1146
  byte   HPNJU02 1147-1148
  byte   HPNJL02 1149-1150
  byte   HPNAU02 1151-1152
  byte   HPNSE02 1153-1154
  byte   HPNOC02 1155-1156
  byte   HPNNO02 1157-1158
  byte   HPNDE02 1159-1160
  byte   HPOJA02 1161-1162
  byte   HPOFE02 1163-1164
  byte   HPOMA02 1165-1166
  byte   HPOAP02 1167-1168
  byte   HPOMY02 1169-1170
  byte   HPOJU02 1171-1172
  byte   HPOJL02 1173-1174
  byte   HPOAU02 1175-1176
  byte   HPOSE02 1177-1178
  byte   HPOOC02 1179-1180
  byte   HPONO02 1181-1182
  byte   HPODE02 1183-1184
  byte   HPSJA02 1185-1186
  byte   HPSFE02 1187-1188
  byte   HPSMA02 1189-1190
  byte   HPSAP02 1191-1192
  byte   HPSMY02 1193-1194
  byte   HPSJU02 1195-1196
  byte   HPSJL02 1197-1198
  byte   HPSAU02 1199-1200
  byte   HPSSE02 1201-1202
  byte   HPSOC02 1203-1204
  byte   HPSNO02 1205-1206
  byte   HPSDE02 1207-1208
  byte   HPRJA02 1209-1210
  byte   HPRFE02 1211-1212
  byte   HPRMA02 1213-1214
  byte   HPRAP02 1215-1216
  byte   HPRMY02 1217-1218
  byte   HPRJU02 1219-1220
  byte   HPRJL02 1221-1222
  byte   HPRAU02 1223-1224
  byte   HPRSE02 1225-1226
  byte   HPROC02 1227-1228
  byte   HPRNO02 1229-1230
  byte   HPRDE02 1231-1232
  byte   INSJA02X 1233-1234
  byte   INSFE02X 1235-1236
  byte   INSMA02X 1237-1238
  byte   INSAP02X 1239-1240
  byte   INSMY02X 1241-1242
  byte   INSJU02X 1243-1244
  byte   INSJL02X 1245-1246
  byte   INSAU02X 1247-1248
  byte   INSSE02X 1249-1250
  byte   INSOC02X 1251-1252
  byte   INSNO02X 1253-1254
  byte   INSDE02X 1255-1256
  byte   PRVEV02 1257-1257
  byte   TRIEV02 1258-1258
  byte   MCREV02 1259-1259
  byte   MCDEV02 1260-1260
  byte   OPAEV02 1261-1261
  byte   OPBEV02 1262-1262
  byte   UNINS02 1263-1263
  byte   INSCOV02 1264-1264
  byte   TRIST31X 1265-1266
  byte   TRIST42X 1267-1268
  byte   TRIST02X 1269-1270
  byte   TRIPR31X 1271-1272
  byte   TRIPR42X 1273-1274
  byte   TRIPR02X 1275-1276
  byte   TRIEX31X 1277-1278
  byte   TRIEX42X 1279-1280
  byte   TRIEX02X 1281-1282
  byte   TRILI42X 1283-1284
  byte   TRILI02X 1285-1286
  byte   MCDHMO31 1287-1288
  byte   MCDHMO42 1289-1290
  byte   MCDHMO02 1291-1292
  byte   MCDMC31 1293-1294
  byte   MCDMC42 1295-1296
  byte   MCDMC02 1297-1298
  byte   PRVHMO31 1299-1300
  byte   PRVHMO42 1301-1302
  byte   PRVHMO02 1303-1304
  byte   PRVMNC31 1305-1306
  byte   PRVMNC42 1307-1308
  byte   PRVMNC02 1309-1310
  byte   PRVDRL31 1311-1312
  byte   PRVDRL42 1313-1314
  byte   PRVDRL02 1315-1316
  byte   PHMONP31 1317-1318
  byte   PHMONP42 1319-1320
  byte   PHMONP02 1321-1322
  byte   PMNCNP31 1323-1324
  byte   PMNCNP42 1325-1326
  byte   PMNCNP02 1327-1328
  byte   PRDRNP31 1329-1330
  byte   PRDRNP42 1331-1332
  byte   PRDRNP02 1333-1334
  byte   PREVCOVR 1335-1336
  byte   COVRMM 1337-1338
  int    COVRYY 1339-1342
  byte   WASESTB 1343-1344
  byte   WASMCARE 1345-1346
  byte   WASMCAID 1347-1348
  byte   WASCHAMP 1349-1350
  byte   WASVA 1351-1352
  byte   WASPRIV 1353-1354
  byte   WASOTGOV 1355-1356
  byte   WASAFDC 1357-1358
  byte   WASSSI 1359-1360
  byte   WASSTAT1 1361-1362
  byte   WASSTAT2 1363-1364
  byte   WASSTAT3 1365-1366
  byte   WASOTHER 1367-1368
  byte   NOINSBEF 1369-1370
  byte   NOINSTM 1371-1372
  byte   NOINUNIT 1373-1374
  byte   MORECOVR 1375-1376
  byte   INSENDMM 1377-1378
  int    INSENDYY 1379-1382
  byte   TRICR31X 1383-1384
  byte   TRICR42X 1385-1386
  byte   TRICR53X 1387-1388
  byte   TRICR02X 1389-1390
  byte   TRIAT31X 1391-1392
  byte   TRIAT42X 1393-1394
  byte   TRIAT53X 1395-1396
  byte   TRIAT02X 1397-1398
  byte   MCAID31 1399-1400
  byte   MCAID42 1401-1402
  byte   MCAID53 1403-1404
  byte   MCAID02 1405-1406
  byte   MCAID31X 1407-1408
  byte   MCAID42X 1409-1410
  byte   MCAID53X 1411-1412
  byte   MCAID02X 1413-1414
  byte   MCARE31 1415-1416
  byte   MCARE42 1417-1418
  byte   MCARE53 1419-1420
  byte   MCARE02 1421-1422
  byte   MCARE31X 1423-1424
  byte   MCARE42X 1425-1426
  byte   MCARE53X 1427-1428
  byte   MCARE02X 1429-1430
  byte   MCDAT31X 1431-1432
  byte   MCDAT42X 1433-1434
  byte   MCDAT53X 1435-1436
  byte   MCDAT02X 1437-1438
  byte   OTPAAT31 1439-1440
  byte   OTPAAT42 1441-1442
  byte   OTPAAT53 1443-1444
  byte   OTPAAT02 1445-1446
  byte   OTPBAT31 1447-1448
  byte   OTPBAT42 1449-1450
  byte   OTPBAT53 1451-1452
  byte   OTPBAT02 1453-1454
  byte   OTPUBA31 1455-1456
  byte   OTPUBA42 1457-1458
  byte   OTPUBA53 1459-1460
  byte   OTPUBA02 1461-1462
  byte   OTPUBB31 1463-1464
  byte   OTPUBB42 1465-1466
  byte   OTPUBB53 1467-1468
  byte   OTPUBB02 1469-1470
  byte   PRIDK31 1471-1472
  byte   PRIDK42 1473-1474
  byte   PRIDK53 1475-1476
  byte   PRIDK02 1477-1478
  byte   PRIEU31 1479-1480
  byte   PRIEU42 1481-1482
  byte   PRIEU53 1483-1484
  byte   PRIEU02 1485-1486
  byte   PRING31 1487-1488
  byte   PRING42 1489-1490
  byte   PRING53 1491-1492
  byte   PRING02 1493-1494
  byte   PRIOG31 1495-1496
  byte   PRIOG42 1497-1498
  byte   PRIOG53 1499-1500
  byte   PRIOG02 1501-1502
  byte   PRIS31 1503-1504
  byte   PRIS42 1505-1506
  byte   PRIS53 1507-1508
  byte   PRIS02 1509-1510
  byte   PRIV31 1511-1512
  byte   PRIV42 1513-1514
  byte   PRIV53 1515-1516
  byte   PRIV02 1517-1518
  byte   PRIVAT31 1519-1520
  byte   PRIVAT42 1521-1522
  byte   PRIVAT53 1523-1524
  byte   PRIVAT02 1525-1526
  byte   PROUT31 1527-1528
  byte   PROUT42 1529-1530
  byte   PROUT53 1531-1532
  byte   PROUT02 1533-1534
  byte   PUB31X 1535-1536
  byte   PUB42X 1537-1538
  byte   PUB53X 1539-1540
  byte   PUB02X 1541-1542
  byte   PUBAT31X 1543-1544
  byte   PUBAT42X 1545-1546
  byte   PUBAT53X 1547-1548
  byte   PUBAT02X 1549-1550
  byte   INS31X 1551-1552
  byte   INS42X 1553-1554
  byte   INS53X 1555-1556
  byte   INS02X 1557-1558
  byte   INSAT31X 1559-1560
  byte   INSAT42X 1561-1562
  byte   INSAT53X 1563-1564
  byte   INSAT02X 1565-1566
  byte   STAPR31 1567-1568
  byte   STAPR42 1569-1570
  byte   STAPR53 1571-1572
  byte   STAPR02 1573-1574
  byte   STPRAT31 1575-1576
  byte   STPRAT42 1577-1578
  byte   STPRAT53 1579-1580
  byte   STPRAT02 1581-1582
  byte   DENTIN31 1583-1584
  byte   DENTIN42 1585-1586
  byte   DENTIN53 1587-1588
  byte   PMEDIN31 1589-1590
  byte   PMEDIN42 1591-1592
  byte   PMEDIN53 1593-1594
  byte   GTDCPRBM 1595-1596
  byte   APRVTRTM 1597-1598
  byte   APRVDLYM 1599-1600
  byte   LKINFOM 1601-1602
  byte   PRBINFOM 1603-1604
  byte   CUSTSVCM 1605-1606
  byte   PRBSVCM 1607-1608
  byte   PPRWRKM 1609-1610
  byte   PRBPWKM 1611-1612
  byte   RATPLANM 1613-1614
  byte   GTDCPRBT 1615-1616
  byte   APRVTRTT 1617-1618
  byte   APRVDLYT 1619-1620
  byte   LKINFOT 1621-1622
  byte   PRBINFOT 1623-1624
  byte   CUSTSVCT 1625-1626
  byte   PRBSVCT 1627-1628
  byte   PPRWRKT 1629-1630
  byte   PRBPWKT 1631-1632
  byte   RATPLANT 1633-1634
  int    DDNWRK31 1635-1637
  int    DDNWRK42 1638-1640
  int    DDNWRK53 1641-1643
  int    WKINBD31 1644-1646
  int    WKINBD42 1647-1649
  int    WKINBD53 1650-1652
  byte   DDNSCL31 1653-1654
  int    DDNSCL42 1655-1657
  int    DDNSCL53 1658-1660
  byte   SCLNBD31 1661-1662
  int    SCLNBD42 1663-1665
  int    SCLNBD53 1666-1668
  int    DDBDYS31 1669-1671
  int    DDBDYS42 1672-1674
  int    DDBDYS53 1675-1677
  byte   OTHDYS31 1678-1679
  byte   OTHDYS42 1680-1681
  byte   OTHDYS53 1682-1683
  byte   OTHNDD31 1684-1685
  int    OTHNDD42 1686-1688
  int    OTHNDD53 1689-1691
  byte   ACCELI42 1692-1693
  byte   LANGHM42 1694-1695
  byte   ENGSPK42 1696-1697
  byte   USBORN42 1698-1699
  byte   USLGLV42 1700-1701
  byte   HAVEUS42 1702-1703
  byte   YNOUSC42 1704-1705
  byte   NOREAS42 1706-1707
  byte   SELDSI42 1708-1709
  byte   NEWARE42 1710-1711
  byte   DKWHRU42 1712-1713
  byte   USCNOT42 1714-1715
  byte   PERSLA42 1716-1717
  byte   DIFFPL42 1718-1719
  byte   INSRPL42 1720-1721
  byte   MYSELF42 1722-1723
  byte   CARECO42 1724-1725
  byte   OTHINS42 1726-1727
  byte   JOBRSN42 1728-1729
  byte   NEWDOC42 1730-1731
  byte   DOCELS42 1732-1733
  byte   NOLIKE42 1734-1735
  byte   HEALTH42 1736-1737
  byte   KNOWDR42 1738-1739
  byte   ONJOB42 1740-1741
  byte   NOGODR42 1742-1743
  byte   OTHREA42 1744-1745
  byte   PROVTY42 1746-1747
  byte   FACLPR42 1748-1749
  byte   PLCTYP42 1750-1751
  byte   GOTOUS42 1752-1753
  byte   TMTKUS42 1754-1755
  byte   DFTOUS42 1756-1757
  byte   TYPEPE42 1758-1759
  byte   LOCATN42 1760-1761
  byte   HSPLAP42 1762-1763
  byte   WHITPR42 1764-1765
  byte   BLCKPR42 1766-1767
  byte   ASIANP42 1768-1769
  byte   NATAMP42 1770-1771
  byte   PACISP42 1772-1773
  byte   OTHRCP42 1774-1775
  byte   GENDRP42 1776-1777
  byte   MINORP42 1778-1779
  byte   PREVEN42 1780-1781
  byte   REFFRL42 1782-1783
  byte   ONGONG42 1784-1785
  byte   PHNREG42 1786-1787
  byte   OFFHOU42 1788-1789
  byte   AFTHOU42 1790-1791
  byte   TREATM42 1792-1793
  byte   RESPCT42 1794-1795
  byte   DECIDE42 1796-1797
  byte   CONTRL42 1798-1799
  byte   EXPLOP42 1800-1801
  byte   LANGPR42 1802-1803
  byte   MDUNAB42 1804-1805
  byte   MDUNRS42 1806-1807
  byte   MDUNPR42 1808-1809
  byte   MDDLAY42 1810-1811
  byte   MDDLRS42 1812-1813
  byte   MDDLPR42 1814-1815
  byte   DNUNAB42 1816-1817
  byte   DNUNRS42 1818-1819
  byte   DNUNPR42 1820-1821
  byte   DNDLAY42 1822-1823
  byte   DNDLRS42 1824-1825
  byte   DNDLPR42 1826-1827
  byte   PMUNAB42 1828-1829
  byte   PMUNRS42 1830-1831
  byte   PMUNPR42 1832-1833
  byte   PMDLAY42 1834-1835
  byte   PMDLRS42 1836-1837
  byte   PMDLPR42 1838-1839
  byte   RTHLTH31 1840-1841
  byte   RTHLTH42 1842-1843
  byte   RTHLTH53 1844-1845
  byte   MNHLTH31 1846-1847
  byte   MNHLTH42 1848-1849
  byte   MNHLTH53 1850-1851
  byte   IADLHP31 1852-1853
  byte   IADLHP42 1854-1855
  byte   IADLHP53 1856-1857
  byte   IADL3M31 1858-1859
  byte   IADL3M42 1860-1861
  byte   IADL3M53 1862-1863
  byte   ADLHLP31 1864-1865
  byte   ADLHLP42 1866-1867
  byte   ADLHLP53 1868-1869
  byte   ADL3MO31 1870-1871
  byte   ADL3MO42 1872-1873
  byte   ADL3MO53 1874-1875
  byte   AIDHLP31 1876-1877
  byte   AIDHLP53 1878-1879
  byte   WLKLIM31 1880-1881
  byte   WLKLIM53 1882-1883
  byte   LFTDIF31 1884-1885
  byte   LFTDIF53 1886-1887
  byte   STPDIF31 1888-1889
  byte   STPDIF53 1890-1891
  byte   WLKDIF31 1892-1893
  byte   WLKDIF53 1894-1895
  byte   MILDIF31 1896-1897
  byte   MILDIF53 1898-1899
  byte   STNDIF31 1900-1901
  byte   STNDIF53 1902-1903
  byte   BENDIF31 1904-1905
  byte   BENDIF53 1906-1907
  byte   RCHDIF31 1908-1909
  byte   RCHDIF53 1910-1911
  byte   FNGRDF31 1912-1913
  byte   FNGRDF53 1914-1915
  byte   WLK3MO31 1916-1917
  byte   WLK3MO53 1918-1919
  byte   ACTLIM31 1920-1921
  byte   ACTLIM53 1922-1923
  byte   WRKLIM31 1924-1925
  byte   WRKLIM53 1926-1927
  byte   HSELIM31 1928-1929
  byte   HSELIM53 1930-1931
  byte   SCHLIM31 1932-1933
  byte   SCHLIM53 1934-1935
  byte   UNABLE31 1936-1937
  byte   UNABLE53 1938-1939
  byte   SOCLIM31 1940-1941
  byte   SOCLIM53 1942-1943
  byte   COGLIM31 1944-1945
  byte   COGLIM53 1946-1947
  byte   WRGLAS42 1948-1949
  byte   SEEDIF42 1950-1951
  byte   BLIND42 1952-1953
  byte   READNW42 1954-1955
  byte   RECPEP42 1956-1957
  byte   VISION42 1958-1959
  byte   HEARAD42 1960-1961
  byte   HEARDI42 1962-1963
  byte   DEAF42 1964-1965
  byte   HEARMO42 1966-1967
  byte   HEARSM42 1968-1969
  byte   HEARNG42 1970-1971
  byte   ANYLIM02 1972-1973
  byte   LSHLTH42 1974-1975
  byte   NEVILL42 1976-1977
  byte   SICEAS42 1978-1979
  byte   HLTHLF42 1980-1981
  byte   WRHLTH42 1982-1983
  byte   CHPMED42 1984-1985
  byte   CHPMHB42 1986-1987
  byte   CHPMCN42 1988-1989
  byte   CHSERV42 1990-1991
  byte   CHSRHB42 1992-1993
  byte   CHSRCN42 1994-1995
  byte   CHLIMI42 1996-1997
  byte   CHLIHB42 1998-1999
  byte   CHLICO42 2000-2001
  byte   CHTHER42 2002-2003
  byte   CHTHHB42 2004-2005
  byte   CHTHCO42 2006-2007
  byte   CHCOUN42 2008-2009
  byte   CHEMPB42 2010-2011
  byte   CSHCN42 2012-2013
  byte   MOMPRO42 2014-2015
  byte   DADPRO42 2016-2017
  byte   UNHAP42 2018-2019
  byte   SCHLBH42 2020-2021
  byte   HAVFUN42 2022-2023
  byte   ADUPRO42 2024-2025
  byte   NERVAF42 2026-2027
  byte   SIBPRO42 2028-2029
  byte   KIDPRO42 2030-2031
  byte   SPRPRO42 2032-2033
  byte   SCHPRO42 2034-2035
  byte   HOMEBH42 2036-2037
  byte   TRBLE42 2038-2039
  byte   CHRTCR42 2040-2041
  byte   CHRTWW42 2042-2043
  byte   CHILCR42 2044-2045
  byte   CHILWW42 2046-2047
  byte   CHAPPT42 2048-2049
  byte   CHNDCR42 2050-2051
  byte   CHNECP42 2052-2053
  byte   CHLIST42 2054-2055
  byte   CHEXPL42 2056-2057
  byte   CHRESP42 2058-2059
  byte   CHPRTM42 2060-2061
  byte   CHHECR42 2062-2063
  byte   CHSPEC42 2064-2065
  byte   CHPRRE42 2066-2067
  byte   MESHGT42 2068-2069
  byte   WHNHGT42 2070-2071
  byte   MESWGT42 2072-2073
  byte   WHNWGT42 2074-2075
  double CHBMIX42 2076-2080
  byte   MESVIS42 2081-2082
  byte   MESBPR42 2083-2084
  byte   WHNBPR42 2085-2086
  byte   DENTAL42 2087-2088
  byte   WHNDEN42 2089-2090
  byte   EATHLT42 2091-2092
  byte   WHNEAT42 2093-2094
  byte   PHYSCL42 2095-2096
  byte   WHNPHY42 2097-2098
  byte   SAFEST42 2099-2100
  byte   WHNSAF42 2101-2102
  byte   BOOST42 2103-2104
  byte   WHNBST42 2105-2106
  byte   LAPBLT42 2107-2108
  byte   WHNLAP42 2109-2110
  byte   HELMET42 2111-2112
  byte   WHNHEL42 2113-2114
  byte   NOSMOK42 2115-2116
  byte   WHNSMK42 2117-2118
  byte   TIMALN42 2119-2120
  byte   DENTCK53 2121-2122
  byte   CHOLCK53 2123-2124
  byte   CHECK53 2125-2126
  byte   FLUSHT53 2127-2128
  byte   LSTETH53 2129-2130
  byte   PSA53 2131-2132
  byte   HYSTER53 2133-2134
  byte   PAPSMR53 2135-2136
  byte   BRSTEX53 2137-2138
  byte   MAMOGR53 2139-2140
  byte   STOOL53 2141-2142
  byte   WHENST53 2143-2144
  byte   BOWEL53 2145-2146
  byte   WHNBWL53 2147-2148
  byte   PHYACT53 2149-2150
  double BMINDX53 2151-2155
  byte   SEATBE53 2156-2157
  byte   SRTHRT53 2158-2159
  byte   THSYMP53 2160-2161
  byte   DRTHRT53 2162-2163
  byte   THANTB53 2164-2165
  byte   THSWAB53 2166-2167
  byte   THSYMF53 2168-2169
  byte   THSWBF53 2170-2171
  byte   THANTF53 2172-2173
  byte   DIABDX53 2174-2175
  byte   ASTHDX53 2176-2177
  byte   ASATAK53 2178-2179
  byte   ASMED53 2180-2181
  byte   ASSTER53 2182-2183
  byte   ASFLOW53 2184-2185
  byte   HIBPDX53 2186-2187
  byte   BPMLDX53 2188-2189
  byte   BPCHEK53 2190-2191
  byte   BPMONT53 2192-2193
  byte   CHDDX53 2194-2195
  byte   ANGIDX53 2196-2197
  byte   MIDX53 2198-2199
  byte   OHRTDX53 2200-2201
  byte   STRKDX53 2202-2203
  byte   EMPHDX53 2204-2205
  byte   NOFAT53 2206-2207
  byte   EXRCIS53 2208-2209
  byte   ASPRIN53 2210-2211
  byte   NOASPR53 2212-2213
  byte   STOMCH53 2214-2215
  byte   JTPAIN53 2216-2217
  byte   ARTHDX53 2218-2219
  byte   ARTHTX53 2220-2221
  byte   SAQELIG 2222-2222
  int    ADPRX42 2223-2225
  byte   ADILCR42 2226-2227
  byte   ADILWW42 2228-2229
  byte   ADRTCR42 2230-2231
  byte   ADRTWW42 2232-2233
  byte   ADAPPT42 2234-2235
  byte   ADNDCR42 2236-2237
  byte   ADNECP42 2238-2239
  byte   ADLIST42 2240-2241
  byte   ADEXPL42 2242-2243
  byte   ADRESP42 2244-2245
  byte   ADPRTM42 2246-2247
  byte   ADHECR42 2248-2249
  byte   ADSMOK42 2250-2251
  byte   ADDSMK42 2252-2253
  byte   ADDRBP42 2254-2255
  byte   ADSPEC42 2256-2257
  byte   ADPRRE42 2258-2259
  byte   ADGENH42 2260-2261
  byte   ADDAYA42 2262-2263
  byte   ADCLIM42 2264-2265
  byte   ADPACC42 2266-2267
  byte   ADPLMT42 2268-2269
  double PCS42 2270-2274
  byte   ADMACC42 2275-2276
  byte   ADMLMT42 2277-2278
  double MCS42 2279-2283
  byte   SFFLAG42 2284-2284
  byte   ADPAIN42 2285-2286
  byte   ADCALM42 2287-2288
  byte   ADPEP42 2289-2290
  byte   ADBLUE42 2291-2292
  byte   ADSOCA42 2293-2294
  byte   ADMOBI42 2295-2296
  byte   ADSELF42 2297-2298
  byte   ADACTI42 2299-2300
  byte   ADPAYN42 2301-2302
  byte   ADDEPR42 2303-2304
  int    ADSCAL42 2305-2307
  double EQU42 2308-2312
  byte   ADINSA42 2313-2314
  byte   ADINSB42 2315-2316
  byte   ADRISK42 2317-2318
  byte   ADOVER42 2319-2320
  byte   ADCMPM42 2321-2322
  byte   ADCMPD42 2323-2324
  int    ADCMPY42 2325-2328
  byte   ADLANG42 2329-2330
  byte   DSDIA53 2331-2332
  byte   DSA1C53 2333-2334
  byte   DSCKFT53 2335-2336
  byte   DSEY0353 2337-2338
  byte   DSEY0253 2339-2340
  byte   DSEY0153 2341-2342
  byte   DSEB0153 2343-2344
  byte   DSEYNV53 2345-2346
  byte   DSKIDN53 2347-2348
  byte   DSEYPR53 2349-2350
  byte   DSDIET53 2351-2352
  byte   DSMED53 2353-2354
  byte   DSINSU53 2355-2356
  byte   DSPRX53 2357-2358
  long   TOTTCH02 2359-2364
  long   TOTEXP02 2365-2370
  long   TOTSLF02 2371-2375
  long   TOTMCR02 2376-2381
  long   TOTMCD02 2382-2387
  long   TOTPRV02 2388-2393
  long   TOTVA02 2394-2399
  long   TOTTRI02 2400-2405
  long   TOTOFD02 2406-2410
  long   TOTSTL02 2411-2415
  long   TOTWCP02 2416-2421
  long   TOTOPR02 2422-2427
  long   TOTOPU02 2428-2432
  long   TOTOSR02 2433-2437
  int    OBTOTV02 2438-2440
  long   OBVTCH02 2441-2446
  long   OBVEXP02 2447-2451
  long   OBVSLF02 2452-2456
  long   OBVMCR02 2457-2461
  long   OBVMCD02 2462-2466
  long   OBVPRV02 2467-2471
  long   OBVVA02 2472-2476
  long   OBVTRI02 2477-2481
  int    OBVOFD02 2482-2485
  long   OBVSTL02 2486-2490
  long   OBVWCP02 2491-2495
  long   OBVOPR02 2496-2500
  long   OBVOPU02 2501-2505
  long   OBVOSR02 2506-2510
  int    OBDRV02 2511-2513
  long   OBDTCH02 2514-2519
  long   OBDEXP02 2520-2524
  long   OBDSLF02 2525-2529
  long   OBDMCR02 2530-2534
  long   OBDMCD02 2535-2539
  long   OBDPRV02 2540-2544
  int    OBDVA02 2545-2548
  long   OBDTRI02 2549-2553
  int    OBDOFD02 2554-2557
  long   OBDSTL02 2558-2562
  int    OBDWCP02 2563-2566
  long   OBDOPR02 2567-2571
  long   OBDOPU02 2572-2576
  long   OBDOSR02 2577-2581
  int    OBOTHV02 2582-2584
  long   OBOTCH02 2585-2589
  long   OBOEXP02 2590-2594
  long   OBOSLF02 2595-2599
  long   OBOMCR02 2600-2604
  long   OBOMCD02 2605-2609
  long   OBOPRV02 2610-2614
  long   OBOVA02 2615-2619
  int    OBOTRI02 2620-2623
  int    OBOOFD02 2624-2627
  int    OBOSTL02 2628-2631
  int    OBOWCP02 2632-2635
  long   OBOOPR02 2636-2640
  int    OBOOPU02 2641-2644
  long   OBOOSR02 2645-2649
  int    OBCHIR02 2650-2652
  long   OBCTCH02 2653-2657
  long   OBCEXP02 2658-2662
  long   OBCSLF02 2663-2667
  int    OBCMCR02 2668-2671
  int    OBCMCD02 2672-2675
  int    OBCPRV02 2676-2679
  int    OBCVA02 2680-2683
  int    OBCTRI02 2684-2686
  int    OBCOFD02 2687-2690
  int    OBCSTL02 2691-2693
  int    OBCWCP02 2694-2697
  int    OBCOPR02 2698-2701
  byte   OBCOPU02 2702-2702
  int    OBCOSR02 2703-2706
  int    OBNURS02 2707-2709
  long   OBNTCH02 2710-2714
  long   OBNEXP02 2715-2719
  long   OBNSLF02 2720-2724
  long   OBNMCR02 2725-2729
  long   OBNMCD02 2730-2734
  long   OBNPRV02 2735-2739
  int    OBNVA02 2740-2743
  int    OBNTRI02 2744-2747
  int    OBNOFD02 2748-2751
  int    OBNSTL02 2752-2754
  int    OBNWCP02 2755-2758
  int    OBNOPR02 2759-2762
  int    OBNOPU02 2763-2766
  int    OBNOSR02 2767-2770
  byte   OBOPTO02 2771-2772
  long   OBETCH02 2773-2777
  int    OBEEXP02 2778-2781
  int    OBESLF02 2782-2785
  int    OBEMCR02 2786-2789
  int    OBEMCD02 2790-2793
  int    OBEPRV02 2794-2797
  int    OBEVA02 2798-2801
  int    OBETRI02 2802-2804
  int    OBEOFD02 2805-2808
  int    OBESTL02 2809-2811
  byte   OBEWCP02 2812-2813
  int    OBEOPR02 2814-2816
  int    OBEOPU02 2817-2819
  int    OBEOSR02 2820-2822
  byte   OBASST02 2823-2824
  long   OBATCH02 2825-2829
  int    OBAEXP02 2830-2833
  int    OBASLF02 2834-2836
  int    OBAMCR02 2837-2840
  int    OBAMCD02 2841-2844
  int    OBAPRV02 2845-2848
  int    OBAVA02 2849-2852
  int    OBATRI02 2853-2856
  int    OBAOFD02 2857-2860
  int    OBASTL02 2861-2863
  int    OBAWCP02 2864-2867
  int    OBAOPR02 2868-2870
  byte   OBAOPU02 2871-2872
  int    OBAOSR02 2873-2875
  byte   OBTHER02 2876-2877
  long   OBTTCH02 2878-2882
  long   OBTEXP02 2883-2887
  int    OBTSLF02 2888-2891
  long   OBTMCR02 2892-2896
  int    OBTMCD02 2897-2900
  long   OBTPRV02 2901-2905
  int    OBTVA02 2906-2909
  int    OBTTRI02 2910-2913
  int    OBTOFD02 2914-2917
  int    OBTSTL02 2918-2921
  int    OBTWCP02 2922-2925
  int    OBTOPR02 2926-2929
  int    OBTOPU02 2930-2932
  int    OBTOSR02 2933-2936
  int    OPTOTV02 2937-2939
  long   OPFTCH02 2940-2945
  long   OPFEXP02 2946-2951
  long   OPFSLF02 2952-2956
  long   OPFMCR02 2957-2962
  long   OPFMCD02 2963-2967
  long   OPFPRV02 2968-2972
  long   OPFVA02 2973-2977
  long   OPFTRI02 2978-2982
  long   OPFOFD02 2983-2987
  int    OPFSTL02 2988-2991
  int    OPFWCP02 2992-2995
  int    OPFOPR02 2996-2999
  int    OPFOPU02 3000-3003
  long   OPFOSR02 3004-3008
  long   OPDEXP02 3009-3013
  long   OPDTCH02 3014-3018
  long   OPDSLF02 3019-3023
  int    OPDMCR02 3024-3027
  int    OPDMCD02 3028-3031
  long   OPDPRV02 3032-3036
  int    OPDVA02 3037-3039
  int    OPDTRI02 3040-3043
  int    OPDOFD02 3044-3046
  int    OPDSTL02 3047-3049
  int    OPDWCP02 3050-3053
  long   OPDOPR02 3054-3058
  int    OPDOPU02 3059-3061
  int    OPDOSR02 3062-3064
  byte   OPDRV02 3065-3066
  long   OPVTCH02 3067-3071
  long   OPVEXP02 3072-3076
  long   OPVSLF02 3077-3081
  long   OPVMCR02 3082-3086
  long   OPVMCD02 3087-3091
  long   OPVPRV02 3092-3096
  long   OPVVA02 3097-3101
  long   OPVTRI02 3102-3106
  int    OPVOFD02 3107-3110
  int    OPVSTL02 3111-3114
  int    OPVWCP02 3115-3118
  int    OPVOPR02 3119-3122
  int    OPVOPU02 3123-3126
  long   OPVOSR02 3127-3131
  long   OPSEXP02 3132-3136
  long   OPSTCH02 3137-3141
  long   OPSSLF02 3142-3146
  int    OPSMCR02 3147-3150
  int    OPSMCD02 3151-3154
  long   OPSPRV02 3155-3159
  int    OPSVA02 3160-3162
  int    OPSTRI02 3163-3166
  byte   OPSOFD02 3167-3167
  int    OPSSTL02 3168-3170
  int    OPSWCP02 3171-3174
  long   OPSOPR02 3175-3179
  int    OPSOPU02 3180-3182
  int    OPSOSR02 3183-3185
  int    OPOTHV02 3186-3188
  long   OPOTCH02 3189-3194
  long   OPOEXP02 3195-3200
  long   OPOSLF02 3201-3205
  long   OPOMCR02 3206-3211
  long   OPOMCD02 3212-3216
  long   OPOPRV02 3217-3221
  long   OPOVA02 3222-3226
  int    OPOTRI02 3227-3230
  int    OPOOFD02 3231-3234
  int    OPOSTL02 3235-3238
  int    OPOWCP02 3239-3242
  int    OPOOPR02 3243-3246
  int    OPOOPU02 3247-3249
  long   OPOOSR02 3250-3254
  long   OPPEXP02 3255-3259
  long   OPPTCH02 3260-3264
  int    OPPSLF02 3265-3268
  int    OPPMCR02 3269-3272
  int    OPPMCD02 3273-3276
  long   OPPPRV02 3277-3281
  int    OPPVA02 3282-3284
  int    OPPTRI02 3285-3287
  int    OPPOFD02 3288-3290
  byte   OPPSTL02 3291-3292
  int    OPPWCP02 3293-3296
  int    OPPOPR02 3297-3300
  int    OPPOPU02 3301-3303
  int    OPPOSR02 3304-3306
  int    AMCHIR02 3307-3309
  long   AMCTCH02 3310-3314
  long   AMCEXP02 3315-3319
  long   AMCSLF02 3320-3324
  int    AMCMCR02 3325-3328
  int    AMCMCD02 3329-3332
  int    AMCPRV02 3333-3336
  int    AMCVA02 3337-3340
  int    AMCTRI02 3341-3343
  int    AMCOFD02 3344-3347
  int    AMCSTL02 3348-3350
  int    AMCWCP02 3351-3354
  int    AMCOPR02 3355-3358
  byte   AMCOPU02 3359-3359
  long   AMCOSR02 3360-3364
  int    AMNURS02 3365-3367
  long   AMNTCH02 3368-3373
  long   AMNEXP02 3374-3378
  long   AMNSLF02 3379-3383
  long   AMNMCR02 3384-3388
  long   AMNMCD02 3389-3393
  long   AMNPRV02 3394-3398
  int    AMNVA02 3399-3402
  int    AMNTRI02 3403-3406
  int    AMNOFD02 3407-3410
  int    AMNSTL02 3411-3414
  int    AMNWCP02 3415-3418
  int    AMNOPR02 3419-3422
  int    AMNOPU02 3423-3426
  int    AMNOSR02 3427-3430
  byte   AMOPTO02 3431-3432
  long   AMETCH02 3433-3437
  int    AMEEXP02 3438-3441
  int    AMESLF02 3442-3445
  int    AMEMCR02 3446-3449
  int    AMEMCD02 3450-3453
  int    AMEPRV02 3454-3457
  int    AMEVA02 3458-3461
  int    AMETRI02 3462-3464
  int    AMEOFD02 3465-3468
  int    AMESTL02 3469-3471
  byte   AMEWCP02 3472-3473
  int    AMEOPR02 3474-3476
  int    AMEOPU02 3477-3479
  int    AMEOSR02 3480-3482
  byte   AMASST02 3483-3484
  long   AMATCH02 3485-3489
  long   AMAEXP02 3490-3494
  int    AMASLF02 3495-3497
  int    AMAMCR02 3498-3501
  int    AMAMCD02 3502-3505
  int    AMAPRV02 3506-3509
  long   AMAVA02 3510-3514
  int    AMATRI02 3515-3518
  int    AMAOFD02 3519-3522
  int    AMASTL02 3523-3525
  int    AMAWCP02 3526-3529
  int    AMAOPR02 3530-3532
  byte   AMAOPU02 3533-3534
  int    AMAOSR02 3535-3537
  int    AMTHER02 3538-3540
  long   AMTTCH02 3541-3545
  long   AMTEXP02 3546-3550
  long   AMTSLF02 3551-3555
  long   AMTMCR02 3556-3560
  int    AMTMCD02 3561-3564
  long   AMTPRV02 3565-3569
  long   AMTVA02 3570-3574
  int    AMTTRI02 3575-3578
  int    AMTOFD02 3579-3582
  int    AMTSTL02 3583-3586
  int    AMTWCP02 3587-3590
  int    AMTOPR02 3591-3594
  int    AMTOPU02 3595-3597
  int    AMTOSR02 3598-3601
  byte   AMTOTC02 3602-3603
  byte   AMDRC02 3604-3605
  byte   ERTOT02 3606-3607
  long   ERFTCH02 3608-3613
  long   ERFEXP02 3614-3618
  int    ERFSLF02 3619-3622
  long   ERFMCR02 3623-3627
  long   ERFMCD02 3628-3632
  long   ERFPRV02 3633-3637
  long   ERFVA02 3638-3642
  int    ERFTRI02 3643-3646
  int    ERFOFD02 3647-3650
  long   ERFSTL02 3651-3655
  int    ERFWCP02 3656-3659
  int    ERFOPR02 3660-3663
  int    ERFOPU02 3664-3667
  long   ERFOSR02 3668-3672
  int    ERDEXP02 3673-3676
  long   ERDTCH02 3677-3681
  int    ERDSLF02 3682-3685
  int    ERDMCR02 3686-3689
  int    ERDMCD02 3690-3692
  int    ERDPRV02 3693-3696
  int    ERDVA02 3697-3699
  int    ERDTRI02 3700-3702
  byte   ERDOFD02 3703-3704
  int    ERDSTL02 3705-3707
  int    ERDWCP02 3708-3711
  int    ERDOPR02 3712-3715
  int    ERDOPU02 3716-3718
  int    ERDOSR02 3719-3721
  byte   IPZERO02 3722-3722
  long   ZIFTCH02 3723-3727
  long   ZIFEXP02 3728-3732
  int    ZIFSLF02 3733-3736
  int    ZIFMCR02 3737-3740
  int    ZIFMCD02 3741-3744
  long   ZIFPRV02 3745-3749
  byte   ZIFVA02 3750-3751
  int    ZIFTRI02 3752-3754
  byte   ZIFOFD02 3755-3755
  byte   ZIFSTL02 3756-3756
  long   ZIFWCP02 3757-3761
  int    ZIFOPR02 3762-3765
  int    ZIFOPU02 3766-3768
  int    ZIFOSR02 3769-3772
  long   ZIDEXP02 3773-3777
  long   ZIDTCH02 3778-3782
  int    ZIDSLF02 3783-3786
  int    ZIDMCR02 3787-3790
  int    ZIDMCD02 3791-3793
  long   ZIDPRV02 3794-3798
  byte   ZIDVA02 3799-3799
  byte   ZIDTRI02 3800-3800
  byte   ZIDOFD02 3801-3801
  byte   ZIDSTL02 3802-3802
  int    ZIDWCP02 3803-3805
  long   ZIDOPR02 3806-3810
  int    ZIDOPU02 3811-3813
  byte   ZIDOSR02 3814-3814
  byte   IPDIS02 3815-3816
  long   IPFEXP02 3817-3822
  long   IPFTCH02 3823-3828
  long   IPFSLF02 3829-3833
  long   IPFMCR02 3834-3839
  long   IPFMCD02 3840-3845
  long   IPFPRV02 3846-3851
  long   IPFVA02 3852-3857
  long   IPFTRI02 3858-3863
  long   IPFOFD02 3864-3868
  long   IPFSTL02 3869-3873
  long   IPFWCP02 3874-3878
  long   IPFOPR02 3879-3884
  long   IPFOPU02 3885-3889
  long   IPFOSR02 3890-3894
  long   IPDEXP02 3895-3899
  long   IPDTCH02 3900-3905
  int    IPDSLF02 3906-3909
  long   IPDMCR02 3910-3914
  int    IPDMCD02 3915-3918
  long   IPDPRV02 3919-3923
  int    IPDVA02 3924-3926
  int    IPDTRI02 3927-3930
  int    IPDOFD02 3931-3933
  int    IPDSTL02 3934-3937
  long   IPDWCP02 3938-3942
  long   IPDOPR02 3943-3947
  int    IPDOPU02 3948-3951
  int    IPDOSR02 3952-3955
  int    IPNGTD02 3956-3958
  byte   DVTOT02 3959-3960
  long   DVTTCH02 3961-3965
  long   DVTEXP02 3966-3970
  long   DVTSLF02 3971-3975
  int    DVTMCR02 3976-3979
  int    DVTMCD02 3980-3983
  long   DVTPRV02 3984-3988
  int    DVTVA02 3989-3992
  int    DVTTRI02 3993-3996
  int    DVTOFD02 3997-4000
  int    DVTSTL02 4001-4004
  int    DVTWCP02 4005-4008
  int    DVTOPR02 4009-4012
  int    DVTOPU02 4013-4015
  int    DVTOSR02 4016-4019
  byte   DVGEN02 4020-4021
  long   DVGTCH02 4022-4026
  long   DVGEXP02 4027-4031
  long   DVGSLF02 4032-4036
  int    DVGMCR02 4037-4040
  int    DVGMCD02 4041-4044
  long   DVGPRV02 4045-4049
  int    DVGVA02 4050-4053
  int    DVGTRI02 4054-4057
  int    DVGOFD02 4058-4061
  int    DVGSTL02 4062-4065
  int    DVGWCP02 4066-4069
  int    DVGOPR02 4070-4073
  int    DVGOPU02 4074-4076
  int    DVGOSR02 4077-4080
  byte   DVORTH02 4081-4082
  long   DVOTCH02 4083-4087
  long   DVOEXP02 4088-4092
  int    DVOSLF02 4093-4096
  byte   DVOMCR02 4097-4097
  int    DVOMCD02 4098-4101
  long   DVOPRV02 4102-4106
  int    DVOVA02 4107-4109
  int    DVOTRI02 4110-4113
  int    DVOOFD02 4114-4116
  int    DVOSTL02 4117-4119
  byte   DVOWCP02 4120-4120
  int    DVOOPR02 4121-4124
  int    DVOOPU02 4125-4127
  int    DVOOSR02 4128-4131
  int    HHTOTD02 4132-4134
  int    HHAGD02 4135-4137
  long   HHATCH02 4138-4143
  long   HHAEXP02 4144-4149
  long   HHASLF02 4150-4154
  long   HHAMCR02 4155-4159
  long   HHAMCD02 4160-4165
  long   HHAPRV02 4166-4170
  int    HHAVA02 4171-4174
  byte   HHATRI02 4175-4175
  int    HHAOFD02 4176-4179
  long   HHASTL02 4180-4184
  byte   HHAWCP02 4185-4185
  long   HHAOPR02 4186-4190
  int    HHAOPU02 4191-4194
  int    HHAOSR02 4195-4197
  int    HHINDD02 4198-4200
  long   HHNTCH02 4201-4205
  long   HHNEXP02 4206-4210
  long   HHNSLF02 4211-4215
  long   HHNMCR02 4216-4220
  int    HHNMCD02 4221-4224
  int    HHNPRV02 4225-4228
  byte   HHNVA02 4229-4230
  byte   HHNTRI02 4231-4231
  byte   HHNOFD02 4232-4232
  int    HHNSTL02 4233-4236
  byte   HHNWCP02 4237-4237
  int    HHNOPR02 4238-4241
  int    HHNOPU02 4242-4244
  int    HHNOSR02 4245-4247
  int    HHINFD02 4248-4250
  int    VISEXP02 4251-4254
  int    VISTCH02 4255-4258
  int    VISSLF02 4259-4262
  int    VISMCR02 4263-4266
  int    VISMCD02 4267-4270
  int    VISPRV02 4271-4274
  int    VISVA02 4275-4278
  int    VISTRI02 4279-4281
  int    VISOFD02 4282-4284
  int    VISSTL02 4285-4287
  int    VISWCP02 4288-4290
  int    VISOPR02 4291-4293
  int    VISOPU02 4294-4296
  int    VISOSR02 4297-4299
  long   OTHTCH02 4300-4304
  long   OTHEXP02 4305-4309
  long   OTHSLF02 4310-4314
  int    OTHMCR02 4315-4318
  int    OTHMCD02 4319-4322
  long   OTHPRV02 4323-4327
  int    OTHVA02 4328-4331
  int    OTHTRI02 4332-4335
  int    OTHOFD02 4336-4338
  int    OTHSTL02 4339-4342
  int    OTHWCP02 4343-4345
  int    OTHOPR02 4346-4349
  int    OTHOPU02 4350-4352
  int    OTHOSR02 4353-4356
  int    RXTOT02 4357-4359
  long   RXEXP02 4360-4365
  long   RXSLF02 4366-4370
  long   RXMCR02 4371-4375
  long   RXMCD02 4376-4381
  long   RXPRV02 4382-4386
  int    RXVA02 4387-4390
  int    RXTRI02 4391-4394
  int    RXOFD02 4395-4398
  int    RXSTL02 4399-4402
  int    RXWCP02 4403-4406
  int    RXOPR02 4407-4410
  int    RXOPU02 4411-4413
  int    RXOSR02 4414-4417
  double PERWT02F 4418-4429
  double FAMWT02F 4430-4441
  double FAMWT02C 4442-4453
  double SAQWT02F 4454-4465
  double DIABW02F 4466-4477
  int    VARSTR 4478-4480
  byte   VARPSU 4481-4481
using H70.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL02 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID02 "FAMILY ID (STUDENT MERGED IN) - 12/31/02";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-02";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-02";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR02 "RU LETTER AS OF 12/31/02";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE02 "RU SIZE AS OF 12/31/02";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS02 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/02";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE02 "RU SIZE INCLUDING STUDENT AS OF 12/31/02";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION02 "CENSUS REGION AS OF 12/31/02";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA02 "MSA AS OF 12/31/02";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS02 "REFERENCE PERSON AS OF 12/31/02";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP02 "1ST RESPONDENT INDICATOR AS OF 12/31/02";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY02 "WAS RESPONDENT A PROXY AS OF 12/31/02";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD02 "2002 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM02 "2002 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY02 "2002 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP02 "INSCOPE - R5/3 START THROUGH 12/31/02";
label variable INSC1231 "INSCOPE STATUS ON 12/31/02";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2002";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND02 "ELIGIBILITY STATUS AS OF 12/31/02";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE02X "AGE AS OF 12/31/02 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY02X "MARITAL STATUS-12/31/02 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID02 "SPOUSE ID - 12/31/02";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN02 "MARITAL STATUS W/SPOUSE PRESENT-12/31/02";
label variable EDUCYEAR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEGYR "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU02X "STUDENT STATUS IF AGES 17-23 - 12/31/02";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETGULF "SERVED IN PERSIAN GULF/DESERT STORM";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL02X "RELATION TO REF PERS-12/31/02 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS02 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC02 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR02 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL02 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT02 "PERSON S FILING STATUS";
label variable FILER02 "PRIMARY OR SECONDARY FILER";
label variable JTINRU02 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID02 "PID OF SECONDARY FILER";
label variable CLMDEP02 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT02 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU02 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD02 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM02 "TAX FORM PERSON WILL FILE";
label variable DEDUCT02 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED02 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP02 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT02 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST02 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN02 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT02 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL02 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP02X "PERSON S TOTAL INCOME";
label variable POVCAT02 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP02X "PERSON S WAGE INCOME";
label variable WAGIMP02 "WAGE IMPUTATION FLAG";
label variable BUSNP02X "PERSON S BUSINESS INCOME";
label variable BUSIMP02 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP02X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP02 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP02X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP02 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP02X "PERSON S INTEREST INCOME";
label variable INTIMP02 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP02X "PERSON S DIVIDEND INCOME";
label variable DIVIMP02 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP02X "PERSON S SALES INCOME";
label variable SALIMP02 "SALES INCOME IMPUTATION FLAG";
label variable PENSP02X "PERSON S PENSION INCOME";
label variable PENIMP02 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP02X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP02 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP02X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP02 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP02X "PERSON S VETERANS INCOME";
label variable VETIMP02 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP02X "PERSON S IRA INCOME";
label variable IRAIMP02 "IRA INCOME IMPUTATION FLAG";
label variable REFDP02X "PERSON S REFUND INCOME";
label variable REFIMP02 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP02X "PERSON S ALIMONY INCOME";
label variable ALIIMP02 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP02X "PERSON S CHILD SUPPORT";
label variable CHLIMP02 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP02X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP02 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP02X "PERSON S SSI";
label variable SSIIMP02 "SSI IMPUTATION FLAG";
label variable PUBP02X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP02 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP02X "PERSON S OTHER INCOME";
label variable OTHIMP02 "OTHER INCOME IMPUTAION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/02";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable TRIJA02X "COVERED BY TRICARE IN JAN02 (ED)";
label variable TRIFE02X "COVERED BY TRICARE IN FEB02 (ED)";
label variable TRIMA02X "COVERED BY TRICARE IN MAR02 (ED)";
label variable TRIAP02X "COVERED BY TRICARE IN APR02 (ED)";
label variable TRIMY02X "COVERED BY TRICARE IN MAY02 (ED)";
label variable TRIJU02X "COVERED BY TRICARE IN JUN02 (ED)";
label variable TRIJL02X "COVERED BY TRICARE IN JUL02 (ED)";
label variable TRIAU02X "COVERED BY TRICARE IN AUG02 (ED)";
label variable TRISE02X "COVERED BY TRICARE IN SEP02 (ED)";
label variable TRIOC02X "COVERED BY TRICARE IN OCT02 (ED)";
label variable TRINO02X "COVERED BY TRICARE IN NOV02 (ED)";
label variable TRIDE02X "COVERED BY TRICARE IN DEC02 (ED)";
label variable MCRJA02 "COVERED BY MEDICARE IN JAN02";
label variable MCRFE02 "COVERED BY MEDICARE IN FEB02";
label variable MCRMA02 "COVERED BY MEDICARE IN MAR02";
label variable MCRAP02 "COVERED BY MEDICARE IN APR02";
label variable MCRMY02 "COVERED BY MEDICARE IN MAY02";
label variable MCRJU02 "COVERED BY MEDICARE IN JUN02";
label variable MCRJL02 "COVERED BY MEDICARE IN JUL02";
label variable MCRAU02 "COVERED BY MEDICARE IN AUG02";
label variable MCRSE02 "COVERED BY MEDICARE IN SEP02";
label variable MCROC02 "COVERED BY MEDICARE IN OCT02";
label variable MCRNO02 "COVERED BY MEDICARE IN NOV02";
label variable MCRDE02 "COVERED BY MEDICARE IN DEC02";
label variable MCRJA02X "COVERED BY MEDICARE IN JAN02 (ED)";
label variable MCRFE02X "COVERED BY MEDICARE IN FEB02 (ED)";
label variable MCRMA02X "COVERED BY MEDICARE IN MAR02 (ED)";
label variable MCRAP02X "COVERED BY MEDICARE IN APR02 (ED)";
label variable MCRMY02X "COVERED BY MEDICARE IN MAY02 (ED)";
label variable MCRJU02X "COVERED BY MEDICARE IN JUN02 (ED)";
label variable MCRJL02X "COVERED BY MEDICARE IN JUL02 (ED)";
label variable MCRAU02X "COVERED BY MEDICARE IN AUG02 (ED)";
label variable MCRSE02X "COVERED BY MEDICARE IN SEP02 (ED)";
label variable MCROC02X "COVERED BY MEDICARE IN OCT02 (ED)";
label variable MCRNO02X "COVERED BY MEDICARE IN NOV02 (ED)";
label variable MCRDE02X "COVERED BY MEDICARE IN DEC02 (ED)";
label variable MCDJA02 "COV BY MEDICAID OR SCHIP IN JAN02";
label variable MCDFE02 "COV BY MEDICAID OR SCHIP IN FEB02";
label variable MCDMA02 "COV BY MEDICAID OR SCHIP IN MAR02";
label variable MCDAP02 "COV BY MEDICAID OR SCHIP IN APR02";
label variable MCDMY02 "COV BY MEDICAID OR SCHIP IN MAY02";
label variable MCDJU02 "COV BY MEDICAID OR SCHIP IN JUN02";
label variable MCDJL02 "COV BY MEDICAID OR SCHIP IN JUL02";
label variable MCDAU02 "COV BY MEDICAID OR SCHIP IN AUG02";
label variable MCDSE02 "COV BY MEDICAID OR SCHIP IN SEP02";
label variable MCDOC02 "COV BY MEDICAID OR SCHIP IN OCT02";
label variable MCDNO02 "COV BY MEDICAID OR SCHIP IN NOV02";
label variable MCDDE02 "COV BY MEDICAID OR SCHIP IN DEC02";
label variable MCDJA02X "COV BY MEDICAID OR SCHIP IN JAN02 (ED)";
label variable MCDFE02X "COV BY MEDICAID OR SCHIP IN FEB02 (ED)";
label variable MCDMA02X "COV BY MEDICAID OR SCHIP IN MAR02 (ED)";
label variable MCDAP02X "COV BY MEDICAID OR SCHIP IN APR02 (ED)";
label variable MCDMY02X "COV BY MEDICAID OR SCHIP IN MAY02 (ED)";
label variable MCDJU02X "COV BY MEDICAID OR SCHIP IN JUN02 (ED)";
label variable MCDJL02X "COV BY MEDICAID OR SCHIP IN JUL02 (ED)";
label variable MCDAU02X "COV BY MEDICAID OR SCHIP IN AUG02 (ED)";
label variable MCDSE02X "COV BY MEDICAID OR SCHIP IN SEP02 (ED)";
label variable MCDOC02X "COV BY MEDICAID OR SCHIP IN OCT02 (ED)";
label variable MCDNO02X "COV BY MEDICAID OR SCHIP IN NOV02 (ED)";
label variable MCDDE02X "COV BY MEDICAID OR SCHIP IN DEC02 (ED)";
label variable OPAJA02 "COV BY OTHER PUBLIC A INS IN JAN02";
label variable OPAFE02 "COV BY OTHER PUBLIC A INS IN FEB02";
label variable OPAMA02 "COV BY OTHER PUBLIC A INS IN MAR02";
label variable OPAAP02 "COV BY OTHER PUBLIC A INS IN APR02";
label variable OPAMY02 "COV BY OTHER PUBLIC A INS IN MAY02";
label variable OPAJU02 "COV BY OTHER PUBLIC A INS IN JUN02";
label variable OPAJL02 "COV BY OTHER PUBLIC A INS IN JUL02";
label variable OPAAU02 "COV BY OTHER PUBLIC A INS IN AUG02";
label variable OPASE02 "COV BY OTHER PUBLIC A INS IN SEP02";
label variable OPAOC02 "COV BY OTHER PUBLIC A INS IN OCT02";
label variable OPANO02 "COV BY OTHER PUBLIC A INS IN NOV02";
label variable OPADE02 "COV BY OTHER PUBLIC A INS IN DEC02";
label variable OPBJA02 "COV BY OTHER PUBLIC B INS IN JAN02";
label variable OPBFE02 "COV BY OTHER PUBLIC B INS IN FEB02";
label variable OPBMA02 "COV BY OTHER PUBLIC B INS IN MAR02";
label variable OPBAP02 "COV BY OTHER PUBLIC B INS IN APR02";
label variable OPBMY02 "COV BY OTHER PUBLIC B INS IN MAY02";
label variable OPBJU02 "COV BY OTHER PUBLIC B INS IN JUN02";
label variable OPBJL02 "COV BY OTHER PUBLIC B INS IN JUL02";
label variable OPBAU02 "COV BY OTHER PUBLIC B INS IN AUG02";
label variable OPBSE02 "COV BY OTHER PUBLIC B INS IN SEP02";
label variable OPBOC02 "COV BY OTHER PUBLIC B INS IN OCT02";
label variable OPBNO02 "COV BY OTHER PUBLIC B INS IN NOV02";
label variable OPBDE02 "COV BY OTHER PUBLIC B INS IN DEC02";
label variable STAJA02 "COVERED BY OTHER STATE PROG IN JAN02";
label variable STAFE02 "COVERED BY OTHER STATE PROG IN FEB02";
label variable STAMA02 "COVERED BY OTHER STATE PROG IN MAR02";
label variable STAAP02 "COVERED BY OTHER STATE PROG IN APR02";
label variable STAMY02 "COVERED BY OTHER STATE PROG IN MAY02";
label variable STAJU02 "COVERED BY OTHER STATE PROG IN JUN02";
label variable STAJL02 "COVERED BY OTHER STATE PROG IN JUL02";
label variable STAAU02 "COVERED BY OTHER STATE PROG IN AUG02";
label variable STASE02 "COVERED BY OTHER STATE PROG IN SEP02";
label variable STAOC02 "COVERED BY OTHER STATE PROG IN OCT02";
label variable STANO02 "COVERED BY OTHER STATE PROG IN NOV02";
label variable STADE02 "COVERED BY OTHER STATE PROG IN DEC02";
label variable PUBJA02X "COVR BY ANY PUBLIC INS IN JAN02 (ED)";
label variable PUBFE02X "COVR BY ANY PUBLIC INS IN FEB02 (ED)";
label variable PUBMA02X "COVR BY ANY PUBLIC INS IN MAR02 (ED)";
label variable PUBAP02X "COVR BY ANY PUBLIC INS IN APR02 (ED)";
label variable PUBMY02X "COVR BY ANY PUBLIC INS IN MAY02 (ED)";
label variable PUBJU02X "COVR BY ANY PUBLIC INS IN JUN02 (ED)";
label variable PUBJL02X "COVR BY ANY PUBLIC INS IN JUL02 (ED)";
label variable PUBAU02X "COVR BY ANY PUBLIC INS IN AUG02 (ED)";
label variable PUBSE02X "COVR BY ANY PUBLIC INS IN SEP02 (ED)";
label variable PUBOC02X "COVR BY ANY PUBLIC INS IN OCT02 (ED)";
label variable PUBNO02X "COVR BY ANY PUBLIC INS IN NOV02 (ED)";
label variable PUBDE02X "COVR BY ANY PUBLIC INS IN DEC02 (ED)";
label variable PEGJA02 "COVERED BY EMPL UNION INS IN JAN02";
label variable PEGFE02 "COVERED BY EMPL UNION INS IN FEB02";
label variable PEGMA02 "COVERED BY EMPL UNION INS IN MAR02";
label variable PEGAP02 "COVERED BY EMPL UNION INS IN APR02";
label variable PEGMY02 "COVERED BY EMPL UNION INS IN MAY02";
label variable PEGJU02 "COVERED BY EMPL UNION INS IN JUN02";
label variable PEGJL02 "COVERED BY EMPL UNION INS IN JUL02";
label variable PEGAU02 "COVERED BY EMPL UNION INS IN AUG02";
label variable PEGSE02 "COVERED BY EMPL UNION INS IN SEP02";
label variable PEGOC02 "COVERED BY EMPL UNION INS IN OCT02";
label variable PEGNO02 "COVERED BY EMPL UNION INS IN NOV02";
label variable PEGDE02 "COVERED BY EMPL UNION INS IN DEC02";
label variable PDKJA02 "COVR BY PRIV INS (SOURCE UNKNWN) JAN02";
label variable PDKFE02 "COVR BY PRIV INS (SOURCE UNKNWN) FEB02";
label variable PDKMA02 "COVR BY PRIV INS (SOURCE UNKNWN) MAR02";
label variable PDKAP02 "COVR BY PRIV INS (SOURCE UNKNWN) APR02";
label variable PDKMY02 "COVR BY PRIV INS (SOURCE UNKNWN) MAY02";
label variable PDKJU02 "COVR BY PRIV INS (SOURCE UNKNWN) JUN02";
label variable PDKJL02 "COVR BY PRIV INS (SOURCE UNKNWN) JUL02";
label variable PDKAU02 "COVR BY PRIV INS (SOURCE UNKNWN) AUG02";
label variable PDKSE02 "COVR BY PRIV INS (SOURCE UNKNWN) SEP02";
label variable PDKOC02 "COVR BY PRIV INS (SOURCE UNKNWN) OCT02";
label variable PDKNO02 "COVR BY PRIV INS (SOURCE UNKNWN) NOV02";
label variable PDKDE02 "COVR BY PRIV INS (SOURCE UNKNWN) DEC02";
label variable PNGJA02 "COVERED BY NONGROUP INS IN JAN02";
label variable PNGFE02 "COVERED BY NONGROUP INS IN FEB02";
label variable PNGMA02 "COVERED BY NONGROUP INS IN MAR02";
label variable PNGAP02 "COVERED BY NONGROUP INS IN APR02";
label variable PNGMY02 "COVERED BY NONGROUP INS IN MAY02";
label variable PNGJU02 "COVERED BY NONGROUP INS IN JUN02";
label variable PNGJL02 "COVERED BY NONGROUP INS IN JUL02";
label variable PNGAU02 "COVERED BY NONGROUP INS IN AUG02";
label variable PNGSE02 "COVERED BY NONGROUP INS IN SEP02";
label variable PNGOC02 "COVERED BY NONGROUP INS IN OCT02";
label variable PNGNO02 "COVERED BY NONGROUP INS IN NOV02";
label variable PNGDE02 "COVERED BY NONGROUP INS IN DEC02";
label variable POGJA02 "COVERED BY OTHER GROUP INS IN JAN02";
label variable POGFE02 "COVERED BY OTHER GROUP INS IN FEB02";
label variable POGMA02 "COVERED BY OTHER GROUP INS IN MAR02";
label variable POGAP02 "COVERED BY OTHER GROUP INS IN APR02";
label variable POGMY02 "COVERED BY OTHER GROUP INS IN MAY02";
label variable POGJU02 "COVERED BY OTHER GROUP INS IN JUN02";
label variable POGJL02 "COVERED BY OTHER GROUP INS IN JUL02";
label variable POGAU02 "COVERED BY OTHER GROUP INS IN AUG02";
label variable POGSE02 "COVERED BY OTHER GROUP INS IN SEP02";
label variable POGOC02 "COVERED BY OTHER GROUP INS IN OCT02";
label variable POGNO02 "COVERED BY OTHER GROUP INS IN NOV02";
label variable POGDE02 "COVERED BY OTHER GROUP INS IN DEC02";
label variable PRSJA02 "COVERED BY SELF-EMP-1 INS IN JAN02";
label variable PRSFE02 "COVERED BY SELF-EMP-1 INS IN FEB02";
label variable PRSMA02 "COVERED BY SELF-EMP-1 INS IN MAR02";
label variable PRSAP02 "COVERED BY SELF-EMP-1 INS IN APR02";
label variable PRSMY02 "COVERED BY SELF-EMP-1 INS IN MAY02";
label variable PRSJU02 "COVERED BY SELF-EMP-1 INS IN JUN02";
label variable PRSJL02 "COVERED BY SELF-EMP-1 INS IN JUL02";
label variable PRSAU02 "COVERED BY SELF-EMP-1 INS IN AUG02";
label variable PRSSE02 "COVERED BY SELF-EMP-1 INS IN SEP02";
label variable PRSOC02 "COVERED BY SELF-EMP-1 INS IN OCT02";
label variable PRSNO02 "COVERED BY SELF-EMP-1 INS IN NOV02";
label variable PRSDE02 "COVERED BY SELF-EMP-1 INS IN DEC02";
label variable POUJA02 "COVERED BY HOLDER OUTSIDE OF RU IN JAN02";
label variable POUFE02 "COVERED BY HOLDER OUTSIDE OF RU IN FEB02";
label variable POUMA02 "COVERED BY HOLDER OUTSIDE OF RU IN MAR02";
label variable POUAP02 "COVERED BY HOLDER OUTSIDE OF RU IN APR02";
label variable POUMY02 "COVERED BY HOLDER OUTSIDE OF RU IN MAY02";
label variable POUJU02 "COVERED BY HOLDER OUTSIDE OF RU IN JUN02";
label variable POUJL02 "COVERED BY HOLDER OUTSIDE OF RU IN JUL02";
label variable POUAU02 "COVERED BY HOLDER OUTSIDE OF RU IN AUG02";
label variable POUSE02 "COVERED BY HOLDER OUTSIDE OF RU IN SEP02";
label variable POUOC02 "COVERED BY HOLDER OUTSIDE OF RU IN OCT02";
label variable POUNO02 "COVERED BY HOLDER OUTSIDE OF RU IN NOV02";
label variable POUDE02 "COVERED BY HOLDER OUTSIDE OF RU IN DEC02";
label variable PRIJA02 "COVERED BY PRIVATE INS IN JAN02";
label variable PRIFE02 "COVERED BY PRIVATE INS IN FEB02";
label variable PRIMA02 "COVERED BY PRIVATE INS IN MAR02";
label variable PRIAP02 "COVERED BY PRIVATE INS IN APR02";
label variable PRIMY02 "COVERED BY PRIVATE INS IN MAY02";
label variable PRIJU02 "COVERED BY PRIVATE INS IN JUN02";
label variable PRIJL02 "COVERED BY PRIVATE INS IN JUL02";
label variable PRIAU02 "COVERED BY PRIVATE INS IN AUG02";
label variable PRISE02 "COVERED BY PRIVATE INS IN SEP02";
label variable PRIOC02 "COVERED BY PRIVATE INS IN OCT02";
label variable PRINO02 "COVERED BY PRIVATE INS IN NOV02";
label variable PRIDE02 "COVERED BY PRIVATE INS IN DEC02";
label variable HPEJA02 "HOLDER OF EMPL UNION INS IN JAN02";
label variable HPEFE02 "HOLDER OF EMPL UNION INS IN FEB02";
label variable HPEMA02 "HOLDER OF EMPL UNION INS IN MAR02";
label variable HPEAP02 "HOLDER OF EMPL UNION INS IN APR02";
label variable HPEMY02 "HOLDER OF EMPL UNION INS IN MAY02";
label variable HPEJU02 "HOLDER OF EMPL UNION INS IN JUN02";
label variable HPEJL02 "HOLDER OF EMPL UNION INS IN JUL02";
label variable HPEAU02 "HOLDER OF EMPL UNION INS IN AUG02";
label variable HPESE02 "HOLDER OF EMPL UNION INS IN SEP02";
label variable HPEOC02 "HOLDER OF EMPL UNION INS IN OCT02";
label variable HPENO02 "HOLDER OF EMPL UNION INS IN NOV02";
label variable HPEDE02 "HOLDER OF EMPL UNION INS IN DEC02";
label variable HPDJA02 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN02";
label variable HPDFE02 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB02";
label variable HPDMA02 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR02";
label variable HPDAP02 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR02";
label variable HPDMY02 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY02";
label variable HPDJU02 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN02";
label variable HPDJL02 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL02";
label variable HPDAU02 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG02";
label variable HPDSE02 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP02";
label variable HPDOC02 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT02";
label variable HPDNO02 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV02";
label variable HPDDE02 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC02";
label variable HPNJA02 "HOLDER OF NONGROUP INS IN JAN02";
label variable HPNFE02 "HOLDER OF NONGROUP INS IN FEB02";
label variable HPNMA02 "HOLDER OF NONGROUP INS IN MAR02";
label variable HPNAP02 "HOLDER OF NONGROUP INS IN APR02";
label variable HPNMY02 "HOLDER OF NONGROUP INS IN MAY02";
label variable HPNJU02 "HOLDER OF NONGROUP INS IN JUN02";
label variable HPNJL02 "HOLDER OF NONGROUP INS IN JUL02";
label variable HPNAU02 "HOLDER OF NONGROUP INS IN AUG02";
label variable HPNSE02 "HOLDER OF NONGROUP INS IN SEP02";
label variable HPNOC02 "HOLDER OF NONGROUP INS IN OCT02";
label variable HPNNO02 "HOLDER OF NONGROUP INS IN NOV02";
label variable HPNDE02 "HOLDER OF NONGROUP INS IN DEC02";
label variable HPOJA02 "HOLDER OF OTHER GROUP INS IN JAN02";
label variable HPOFE02 "HOLDER OF OTHER GROUP INS IN FEB02";
label variable HPOMA02 "HOLDER OF OTHER GROUP INS IN MAR02";
label variable HPOAP02 "HOLDER OF OTHER GROUP INS IN APR02";
label variable HPOMY02 "HOLDER OF OTHER GROUP INS IN MAY02";
label variable HPOJU02 "HOLDER OF OTHER GROUP INS IN JUN02";
label variable HPOJL02 "HOLDER OF OTHER GROUP INS IN JUL02";
label variable HPOAU02 "HOLDER OF OTHER GROUP INS IN AUG02";
label variable HPOSE02 "HOLDER OF OTHER GROUP INS IN SEP02";
label variable HPOOC02 "HOLDER OF OTHER GROUP INS IN OCT02";
label variable HPONO02 "HOLDER OF OTHER GROUP INS IN NOV02";
label variable HPODE02 "HOLDER OF OTHER GROUP INS IN DEC02";
label variable HPSJA02 "HOLDER OF SELF-EMP-1 INS IN JAN02";
label variable HPSFE02 "HOLDER OF SELF-EMP-1 INS IN FEB02";
label variable HPSMA02 "HOLDER OF SELF-EMP-1 INS IN MAR02";
label variable HPSAP02 "HOLDER OF SELF-EMP-1 INS IN APR02";
label variable HPSMY02 "HOLDER OF SELF-EMP-1 INS IN MAY02";
label variable HPSJU02 "HOLDER OF SELF-EMP-1 INS IN JUN02";
label variable HPSJL02 "HOLDER OF SELF-EMP-1 INS IN JUL02";
label variable HPSAU02 "HOLDER OF SELF-EMP-1 INS IN AUG02";
label variable HPSSE02 "HOLDER OF SELF-EMP-1 INS IN SEP02";
label variable HPSOC02 "HOLDER OF SELF-EMP-1 INS IN OCT02";
label variable HPSNO02 "HOLDER OF SELF-EMP-1 INS IN NOV02";
label variable HPSDE02 "HOLDER OF SELF-EMP-1 INS IN DEC02";
label variable HPRJA02 "HOLDER OF PRIVATE INSURANCE IN JAN02";
label variable HPRFE02 "HOLDER OF PRIVATE INSURANCE IN FEB02";
label variable HPRMA02 "HOLDER OF PRIVATE INSURANCE IN MAR02";
label variable HPRAP02 "HOLDER OF PRIVATE INSURANCE IN APR02";
label variable HPRMY02 "HOLDER OF PRIVATE INSURANCE IN MAY02";
label variable HPRJU02 "HOLDER OF PRIVATE INSURANCE IN JUN02";
label variable HPRJL02 "HOLDER OF PRIVATE INSURANCE IN JUL02";
label variable HPRAU02 "HOLDER OF PRIVATE INSURANCE IN AUG02";
label variable HPRSE02 "HOLDER OF PRIVATE INSURANCE IN SEP02";
label variable HPROC02 "HOLDER OF PRIVATE INSURANCE IN OCT02";
label variable HPRNO02 "HOLDER OF PRIVATE INSURANCE IN NOV02";
label variable HPRDE02 "HOLDER OF PRIVATE INSURANCE IN DEC02";
label variable INSJA02X "COVR BY HOSP/MED INS IN JAN02 (ED)";
label variable INSFE02X "COVR BY HOSP/MED INS IN FEB02 (ED)";
label variable INSMA02X "COVR BY HOSP/MED INS IN MAR02 (ED)";
label variable INSAP02X "COVR BY HOSP/MED INS IN APR02 (ED)";
label variable INSMY02X "COVR BY HOSP/MED INS IN MAY02 (ED)";
label variable INSJU02X "COVR BY HOSP/MED INS IN JUN02 (ED)";
label variable INSJL02X "COVR BY HOSP/MED INS IN JUL02 (ED)";
label variable INSAU02X "COVR BY HOSP/MED INS IN AUG02 (ED)";
label variable INSSE02X "COVR BY HOSP/MED INS IN SEP02 (ED)";
label variable INSOC02X "COVR BY HOSP/MED INS IN OCT02 (ED)";
label variable INSNO02X "COVR BY HOSP/MED INS IN NOV02 (ED)";
label variable INSDE02X "COVR BY HOSP/MED INS IN DEC02 (ED)";
label variable PRVEV02 "EVER HAVE PRIVATE INSURANCE DURING 02";
label variable TRIEV02 "EVER HAVE TIRCARE DURING 02";
label variable MCREV02 "EVER HAVE MEDICARE DURING 02";
label variable MCDEV02 "EVER HAVE MEDICAID DURING 02";
label variable OPAEV02 "EVER HAVE OTHER PUBLIC A INS DURING 02";
label variable OPBEV02 "EVER HAVE OTHER PUBLIC B INS DURING 02";
label variable UNINS02 "UNINSURED ALL OF 02";
label variable INSCOV02 "HEALTH INSURANCE COVERAGE INDICATOR 02";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST02X "COVERED BY TRICARE STANDARD - 12/31/02";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR02X "COVERED BY TRICARE PRIME - 12/31/02";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX02X "COVERED BY TRICARE EXTRA - 12/31/02";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI02X "COVERED BY TRICARE FOR LIFE - 12/31/02";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO02 "COVRED BY MEDICAID OR SCHIP HMO-12/31/02";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC02 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/02";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO02 "COVERED BY PRIVATE HMO - 12/31/02";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC02 "COVERED BY PRIV GATEKEEPER PLAN-12/31/02";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL02 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/02";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP02 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/02";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP02 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/02";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP02 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/02";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PANL 7 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PANEL 7 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 7 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PNL 7 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 7 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID-PANEL 7 ONLY";
label variable WASCHAMP "WAS PREV INS CHAMPUS/CHAMPVA-PANL 7 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PANL 7 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PNL 7 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PANEL 7 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PANEL 7 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PANEL 7 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PANEL 7 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PANEL 7 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PANEL 7 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 7 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 7 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PNL 7 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 7 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PNL 7 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 7 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 7 ONLY";
label variable TRICR31X "COV BY TRICARE - RD 3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICARE - RD 4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICARE 12-31/R3 INT DT (ED)";
label variable TRICR02X "COV BY TRICARE - 12/31/02 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT02X "ANY TIME COV TRICARE - 12/31/02";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - RD 3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - RD 4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID02 "COV BY MEDICAID OR SCHIP - 12/31/02";
label variable MCAID31X "COV BY MEDICAID/SCHIP-RD 3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP-RD 4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID02X "COV BY MEDICAID OR SCHIP - 12/31/02 (ED)";
label variable MCARE31 "COV BY MEDICARE - RD 3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - RD 4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE02 "COV BY MEDICARE - 12/31/02";
label variable MCARE31X "COV BY MEDICARE-RD 3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE-RD 4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE02X "COV BY MEDICARE - 12/31/02 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT02X "ANY TIME COV MEDICAID OR SCHIP-12/31/02";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT02 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/02";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT02 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/02";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA02 "COV/PAYS OT GOV MCAID/SCHIP HMO-12/31/02";
label variable OTPUBB31 "COV OTH GOV NT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB02 "COV BY OTH GOV NOT MCAID/SCHIP HMO-12/31";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN)-RD3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN)-RD4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK02 "COV BY PRIV INS (DK PLAN) - 12/31/02";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS-R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS-R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU02 "COV BY EMPL/UNION GRP INS - 12/31/02";
label variable PRING31 "COV BY NON-GROUP INS - RD3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - RD4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING02 "COV BY NON-GROUP INS - 12/31/02";
label variable PRIOG31 "COV BY OTHER GROUP INS-RD 3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS-RD 4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG02 "COV BY OTHER GROUP INS - 12/31/02";
label variable PRIS31 "COV BY SELF-EMP-1 INS-RD 3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS-RD 4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS02 "COV BY SELF-EMP-1 INS - 12/31/02";
label variable PRIV31 "COV BY PRIV HLTH INS-RD 3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS-RD 4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV02 "COV BY PRIV HLTH INS - 12/31/02";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT02 "ANY TIME COV PRIVATE INS - 12/31/02";
label variable PROUT31 "COV BY SOMEONE OUT OF RU-RD 3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU-RD 4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT02 "COV BY SOMEONE OUT OF RU - 12/31/02";
label variable PUB31X "COV BY PUBLIC INS-R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS-R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB02X "COV BY PUBLIC INS - 12/31/02 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV PUBLIC INS - R5/3";
label variable PUBAT02X "ANY TIME COV BY PUBLIC - 12/31/02";
label variable INS31X "INSURED - RD 3/1 INT DATE (ED)";
label variable INS42X "INSURED - RD 4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS02X "INSURED - 12/31/02 (ED)";
label variable INSAT31X "INSURED ANY TIME IN RD 3/1";
label variable INSAT42X "INSURED ANY TIME IN RD 4/2";
label variable INSAT53X "INSURED ANY TIME IN RD 5/3";
label variable INSAT02X "INSURED ANY TIME IN R3 UNTIL 12/31/02/R5";
label variable STAPR31 "COV BY STATE-SPEC PROG-R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG-R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR02 "COV BY STATE-SPEC PROG-12/31/02";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COV STATE INS - R5/3";
label variable STPRAT02 "ANY TIME COV BY STATE INS - 12/31/02";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable GTDCPRBM "MCD/O PUB:HOW MUCH PROB GET PERS DOC,R42";
label variable APRVTRTM "MCAID/OTH PUB:NEED APPRVL 4 TREATMNT,R42";
label variable APRVDLYM "MCAID/OTH PUB:DELAY WAITING 4 APPRVL,R42";
label variable LKINFOM "MCAID/OTH PUB:INFO ON HOW PLAN WORKS,R42";
label variable PRBINFOM "MCAID/OTH PUB:PROBLEM FINDING INFO,R42";
label variable CUSTSVCM "MCAID/OTH PUB:CALL CUSTOMER SERVICE,R42";
label variable PRBSVCM "MCD/O PUB:PROB GET HELP FR CUST SRVC,R42";
label variable PPRWRKM "MCD/OTH PUB:FILL OUT PAPERWORK 4 PLN,R42";
label variable PRBPWKM "MCAID/OTH PUB:PROB W PLAN PAPERWORK,R42";
label variable RATPLANM "MCAID/OTH PUB:RATE EXPERIENCE W PLAN,R42";
label variable GTDCPRBT "TRICARE:HOW MUCH PROB GET PERSNL DOC,R42";
label variable APRVTRTT "TRICARE:NEED APPROVAL FOR TREATMENT,R42";
label variable APRVDLYT "TRICARE:DELAY WAITING FOR APPROVAL,R42";
label variable LKINFOT "TRICARE:INFO ON HOW PLAN WORKS,R42";
label variable PRBINFOT "TRICARE:PROBLEM FINDING INFORMATION,R42";
label variable CUSTSVCT "TRICARE:CALL CUSTOMER SERVICE,R42";
label variable PRBSVCT "TRICARE:PROB GET HELP FR CUST SRVC,R42";
label variable PPRWRKT "TRICARE:FILL OUT PAPERWORK FOR PLAN,R42";
label variable PRBPWKT "TRICARE:PROBLEM WITH PLAN PAPERWORK,R42";
label variable RATPLANT "TRICARE:RATE EXPERIENCE WITH PLAN,R42";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ(RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ(RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ(RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSD SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSD SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSD SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD31)";
label variable OTHDYS42 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD42)";
label variable OTHDYS53 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD53)";
label variable OTHNDD31 "# DAY MISSED WRK/SCH CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WRK/SCH CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WRK/SCH CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 PERS LANGUAGE PRFERNCE AT HOME-R4/2";
label variable ENGSPK42 "AC02 PERS COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLGLV42 "AC04 HOW LONG HAS PERS LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC:DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable CONTRL42 "AC29 PROV GIVES PERS CONTROL OF TRT-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM02 "ANY LIMITATION IN P6R3,4,5/P7R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHLD WITH SPECIAL HLTH CARE NEEDS";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (3-17) - R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASMED53 "TAKE MEDS FOR ASTHMA - RD 5/3";
label variable ASSTER53 "TAKE INHALED STEROIDS ASTHMA - RD 5/3";
label variable ASFLOW53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADDSMK42 "SAQ 12 MOS: DR ADVISED QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12";
label variable ADPACC42 "SAQ 4 WKS: DID LESS B/C PHYS PROBS SF-12";
label variable ADPLMT42 "SAQ 4 WKS: LIMIT WK B/C PHYS PROBS SF-12";
label variable PCS42 "SAQ:PHYSICAL COMPNT SUMMARY SF12 IMPUTED";
label variable ADMACC42 "SAQ 4 WKS: DID LESS B/C MENT PROBS SF-12";
label variable ADMLMT42 "SAQ 4 WKS: LIM WK B/C MENT PROBS SF-12";
label variable MCS42 "SAQ:MENTAL COMPONET SUMMARY SF12 IMPUTED";
label variable SFFLAG42 "SAQ:PCS/MCS IMPUTATION FLAG SF-12";
label variable ADPAIN42 "SAQ 4 WKS: PAIN LIMITS NORMAL WORK SF-12";
label variable ADCALM42 "SAQ 4 WKS: FELT CALM/PEACEFUL SF-12";
label variable ADPEP42 "SAQ 4 WKS: HAD A LOT OF ENERGY SF-12";
label variable ADBLUE42 "SAQ 4 WKS: FELT DOWNHEARTED/BLUE SF-12";
label variable ADSOCA42 "SAQ 4 WKS: HLTH STOPPED SOC ACTIV SF-12";
label variable ADMOBI42 "SAQ HEALTH TODAY: MOBILITY EQ-5D";
label variable ADSELF42 "SAQ HEALTH TODAY: SELF-CARE EQ-5D";
label variable ADACTI42 "SAQ HEALTH TODAY: USUAL ACTIVITY EQ-5D";
label variable ADPAYN42 "SAQ HEALTH TODAY: PAIN/DISCOMFORT EQ-5D";
label variable ADDEPR42 "SAQ HLTH TODAY: ANXIETY/DEPRESSION EQ-5D";
label variable ADSCAL42 "SAQ SCALE: HEALTH STATE TODAY EQ-5D";
label variable EQU42 "SAQ: EQ-5D PREFERENCE BASED INDEX";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2002";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2002";
label variable DSEY0353 "DCS: DILATED EYE EXAM IN 2003";
label variable DSEY0253 "DCS: DILATED EYE EXAM IN 2002";
label variable DSEY0153 "DCS: DILATED EYE EXAM IN 2001";
label variable DSEB0153 "DCS: DILATED EYE EXAM BEFORE 2001";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable TOTTCH02 "TOTAL HEALTH CARE CHARGES 02, EXCL RX";
label variable TOTEXP02 "TOTAL HEALTH CARE EXP 02";
label variable TOTSLF02 "TOTAL AMT PAID BY SELF/FAMILY 02";
label variable TOTMCR02 "TOTAL AMT PAID BY MEDICARE 02";
label variable TOTMCD02 "TOTAL AMT PAID BY MEDICAID 02";
label variable TOTPRV02 "TOTAL AMT PAID BY PRIVATE INS 02";
label variable TOTVA02 "TOTAL AMT PAID BY VA 02";
label variable TOTTRI02 "TOTAL AMT PAID BY TRICARE 02";
label variable TOTOFD02 "TOTAL AMT PAID BY OTHER FEDERAL 02";
label variable TOTSTL02 "TOTAL AMT PAID BY OTH ST/LOCAL 02";
label variable TOTWCP02 "TOTAL AMT PAID BY WORKERS COMP 02";
label variable TOTOPR02 "TOTAL AMT PAID BY OTHER PRIVATE 02";
label variable TOTOPU02 "TOTAL AMT PAID BY OTHER PUBLIC 02";
label variable TOTOSR02 "TOTAL AMT PAID BY OTHER SOURCES 02";
label variable OBTOTV02 "# OFFICE-BASED PROVIDER VISITS 02";
label variable OBVTCH02 "OFFICE-BASED PROVIDER VISIT CHARGES 02";
label variable OBVEXP02 "TOTAL OFFICE-BASED EXP 02";
label variable OBVSLF02 "ALL OFFICE VISITS -SELF/FAMILY AMT 02";
label variable OBVMCR02 "ALL OFFICE VISITS -MEDICARE AMT 02";
label variable OBVMCD02 "ALL OFFICE VISITS -MEDICAID AMT 02";
label variable OBVPRV02 "ALL OFFICE VISITS -PRIVATE INS AMT 02";
label variable OBVVA02 "ALL OFFICE VISITS-VA AMT 02";
label variable OBVTRI02 "ALL OFFICE VISITS-TRICARE AMT 02";
label variable OBVOFD02 "ALL OFFICE VISITS-OTHER FEDERAL AMT 02";
label variable OBVSTL02 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 02";
label variable OBVWCP02 "ALL OFFICE VISITS -WORKERS COMP AMT 02";
label variable OBVOPR02 "ALL OFFICE VISITS - OTH PRIVATE AMT 02";
label variable OBVOPU02 "ALL OFFICE VISITS - OTH PUBLIC AMT 02";
label variable OBVOSR02 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBDRV02 "# OFFICE-BASED PHYSICIAN VISITS 02";
label variable OBDTCH02 "OFFICE-BASED PHYSICIAN VISIT CHARGES 02";
label variable OBDEXP02 "TOTAL OFF-BASED DR EXP 02";
label variable OBDSLF02 "DR OFFICE VISITS -SELF/FAMILY AMT 02";
label variable OBDMCR02 "DR OFFICE VISITS -MEDICARE AMT 02";
label variable OBDMCD02 "DR OFFICE VISITS -MEDICAID AMT 02";
label variable OBDPRV02 "DR OFFICE VISITS -PRIVATE INS AMT 02";
label variable OBDVA02 "DR OFFICE VISITS -VA AMT 02";
label variable OBDTRI02 "DR OFFICE VISITS -TRICARE AMT 02";
label variable OBDOFD02 "DR OFFICE VISITS -OTHER FEDERAL AMT 02";
label variable OBDSTL02 "DR OFFICE VISITS -OTH ST/LOCAL AMT 02";
label variable OBDWCP02 "DR OFFICE VISITS -WORKERS COMP AMT 02";
label variable OBDOPR02 "DR OFFICE VISITS - OTH PRIVATE AMT 02";
label variable OBDOPU02 "DR OFFICE VISITS - OTH PUBLIC AMT 02";
label variable OBDOSR02 "DR OFF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBOTHV02 "# OFFICE-BASED NON-PHYSICAN VISITS 02";
label variable OBOTCH02 "OFFICE-BASED NON-DR VISIT CHARGES 02";
label variable OBOEXP02 "TOTAL OFF-BASED NON-DR EXP 02";
label variable OBOSLF02 "NON-DR OFF VISTS -SELF/FAMILY AMT 02";
label variable OBOMCR02 "NON-DR OFF VISTS -MEDICARE AMT 02";
label variable OBOMCD02 "NON-DR OFF VISTS -MEDICAID AMT 02";
label variable OBOPRV02 "NON-DR OFF VISTS -PRIVATE INS AMT 02";
label variable OBOVA02 "NON-DR OFF VISTS -VA AMT 02";
label variable OBOTRI02 "NON-DR OFF VISTS -TRICARE AMT 02";
label variable OBOOFD02 "NON-DR OFF VISTS -OTHER FEDERAL AMT 02";
label variable OBOSTL02 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 02";
label variable OBOWCP02 "NON-DR OFF VISTS -WORKERS COMP AMT 02";
label variable OBOOPR02 "NON-DR OFF VISTS - OTH PRIVATE AMT 02";
label variable OBOOPU02 "NON-DR OFF VISTS - OTH PUBLIC AMT 02";
label variable OBOOSR02 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBCHIR02 "# OFFICE-BASED CHIROPRACTOR VISITS 02";
label variable OBCTCH02 "OFFICE-BASED CHIRO VISIT CHARGES 02";
label variable OBCEXP02 "TOTAL OFF-BASED CHIRO EXP 02";
label variable OBCSLF02 "CHIRO OFF VISITS -SELF/FAMILY AMT 02";
label variable OBCMCR02 "CHIRO OFF VISITS -MEDICARE AMT 02";
label variable OBCMCD02 "CHIRO OFF VISITS -MEDICAID AMT 02";
label variable OBCPRV02 "CHIRO OFF VISITS -PRIVATE INS AMT 02";
label variable OBCVA02 "CHIRO OFF VISITS -VA AMT 02";
label variable OBCTRI02 "CHIRO OFF VISITS -TRICARE AMT 02";
label variable OBCOFD02 "CHIRO OFF VISITS -OTHER FEDERAL AMT 02";
label variable OBCSTL02 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 02";
label variable OBCWCP02 "CHIRO OFF VISITS -WORKERS COMP AMT 02";
label variable OBCOPR02 "CHIRO OFF VISTS - OTHR PRIVATE AMT 02";
label variable OBCOPU02 "CHIRO OFF VISTS - OTHR PUBLIC AMT 02";
label variable OBCOSR02 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 02";
label variable OBNURS02 "# OFF-BASED NURSE/PRACTITIONER VISITS 02";
label variable OBNTCH02 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 02";
label variable OBNEXP02 "TOTAL OFF-BASED NURSE/PRAC 02";
label variable OBNSLF02 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 02";
label variable OBNMCR02 "NURSE/PRAC OFF VISITS -MEDICARE AMT 02";
label variable OBNMCD02 "NURSE/PRAC OFF VSTS -MEDICAID AMT 02";
label variable OBNPRV02 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 02";
label variable OBNVA02 "NURSE/PRAC OFF VSTS -VA AMT 02";
label variable OBNTRI02 "NURSE/PRAC OFF VSTS -TRICARE AMT 02";
label variable OBNOFD02 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 02";
label variable OBNSTL02 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 02";
label variable OBNWCP02 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 02";
label variable OBNOPR02 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 02";
label variable OBNOPU02 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 02";
label variable OBNOSR02 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBOPTO02 "# OFF-BASED OPTOMETRIST VISITS 02";
label variable OBETCH02 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 02";
label variable OBEEXP02 "TOTAL OFF-BASED OPOTMETRIST EXP 02";
label variable OBESLF02 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 02";
label variable OBEMCR02 "OPTOMETRIST OFF VSTS -MEDICARE AMT 02";
label variable OBEMCD02 "OPTOMETRIST OFF VSTS -MEDICAID AMT 02";
label variable OBEPRV02 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 02";
label variable OBEVA02 "OPTOMETRIST OFF VSTS -VA AMT 02";
label variable OBETRI02 "OPTOMETRIST OFF VSTS -TRICARE AMT 02";
label variable OBEOFD02 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 02";
label variable OBESTL02 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 02";
label variable OBEWCP02 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 02";
label variable OBEOPR02 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 02";
label variable OBEOPU02 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 02";
label variable OBEOSR02 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBASST02 "# OFF-BASED PHYSICIAN ASSIST VISITS 02";
label variable OBATCH02 "OFFICE-BASED PHYS ASST VISIT CHARGES 02";
label variable OBAEXP02 "TOTAL OFF-BASED PHYS ASS T EXP 02";
label variable OBASLF02 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 02";
label variable OBAMCR02 "PHYS ASS T OFF VSTS -MEDICARE AMT 02";
label variable OBAMCD02 "PHYS ASS T OFF VSTS -MEDICAID AMT 02";
label variable OBAPRV02 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 02";
label variable OBAVA02 "PHYS ASS T OFF VSTS -VA AMT 02";
label variable OBATRI02 "PHYS ASS T OFF VSTS -TRICARE AMT 02";
label variable OBAOFD02 "PHYS ASS T OFF VSTS -OTHER FED AMT 02";
label variable OBASTL02 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 02";
label variable OBAWCP02 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 02";
label variable OBAOPR02 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 02";
label variable OBAOPU02 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 02";
label variable OBAOSR02 "P A OFF VSTS - OTH UNCLASS SRCE AMT 02";
label variable OBTHER02 "# OFF-BASED PT/OT VISITS 02";
label variable OBTTCH02 "OFFICE-BASED PT/OC VISIT CHARGES 02";
label variable OBTEXP02 "TOT OFF-BASED PT EXP 02";
label variable OBTSLF02 "PT/OT OFF VISITS -SELF/FAMILY AMT 02";
label variable OBTMCR02 "PT/OT OFF VISITS -MEDICARE AMT 02";
label variable OBTMCD02 "PT/OT OFF VISITS -MEDICAID AMT 02";
label variable OBTPRV02 "PT/OT OFF VISITS -PRIVATE INS AMT 02";
label variable OBTVA02 "PT/OT OFF VISITS -VA AMT 02";
label variable OBTTRI02 "PT/OT OFF VISITS -TRICARE AMT 02";
label variable OBTOFD02 "PT/OT OFF VISITS -OTHER FED AMT 02";
label variable OBTSTL02 "PT/OT OFF VISITS -OTH ST/LOCL AMT 02";
label variable OBTWCP02 "PT/OT OFF VISITS -WORKERS COMP AMT 02";
label variable OBTOPR02 "PT/OT OFF VISITS - OTH PRIVATE AMT 02";
label variable OBTOPU02 "PT/OT OFF VISITS - OTH PUBLIC AMT 02";
label variable OBTOSR02 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 02";
label variable OPTOTV02 "# OUTPATIENT DEPT PROVIDER VISITS 02";
label variable OPFTCH02 "OPD PROVIDER VISIT CHARGES - FAC 02";
label variable OPFEXP02 "TOTAL OUTPATIENT FACILITY EXP 02";
label variable OPFSLF02 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 02";
label variable OPFMCR02 "ALL OPD VISITS-MEDICARE AMT-FAC 02";
label variable OPFMCD02 "ALL OPD VISITS-MEDICAID AMT-FAC 02";
label variable OPFPRV02 "ALL OPD VISITS-PRIV INS AMT-FAC 02";
label variable OPFVA02 "ALL OPD VISITS-VA AMT-FAC 02";
label variable OPFTRI02 "ALL OPD VISITS-TRICARE AMT-FAC 02";
label variable OPFOFD02 "ALL OPD VISITS-OTHER FED AMT-FAC 02";
label variable OPFSTL02 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 02";
label variable OPFWCP02 "ALL OPD VISITS-WORKERS COMP AMT-FAC 02";
label variable OPFOPR02 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 02";
label variable OPFOPU02 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 02";
label variable OPFOSR02 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 02";
label variable OPDEXP02 "TOTAL OUTPATIENT PROVIDER EXP 02";
label variable OPDTCH02 "OPD PROVIDER VISIT CHARGES - DR 02";
label variable OPDSLF02 "ALL OPD VISITS-SELF/FAMILY AMT-DR 02";
label variable OPDMCR02 "ALL OPD VISITS-MEDICARE AMT -DR 02";
label variable OPDMCD02 "ALL OPD VISITS-MEDICAID AMT -DR 02";
label variable OPDPRV02 "ALL OPD VISITS-PRIV INS AMT-DR 02";
label variable OPDVA02 "ALL OPD VISITS-VA AMT-DR 02";
label variable OPDTRI02 "ALL OPD VISITS-TRICARE AMT-DR 02";
label variable OPDOFD02 "ALL OPD VISITS-OTHER FED AMT-DR 02";
label variable OPDSTL02 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 02";
label variable OPDWCP02 "ALL OPD VISITS-WORKERS COMP AMT-DR 02";
label variable OPDOPR02 "ALL OPD VISITS - OTH PRIVATE AMT-DR 02";
label variable OPDOPU02 "ALL OPD VISITS-OTH PUBLIC AMT-DR 02";
label variable OPDOSR02 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 02";
label variable OPDRV02 "# OUTPATIENT DEPT PHYSICIAN VISITS 02";
label variable OPVTCH02 "OPD PHYSICIAN VISIT CHARGES - FAC 02";
label variable OPVEXP02 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 02";
label variable OPVSLF02 "OPD DR VISITS-SELF/FAMILY AMT-FAC 02";
label variable OPVMCR02 "OPD DR VISITS-MEDICARE AMT-FAC 02";
label variable OPVMCD02 "OPD DR VISITS-MEDICAID AMT-FAC 02";
label variable OPVPRV02 "OPD DR VISITS-PRIV INS AMT-FAC 02";
label variable OPVVA02 "OPD DR VISITS-VA AMT-FAC 02";
label variable OPVTRI02 "OPD DR VISITS-TRICARE AMT-FAC 02";
label variable OPVOFD02 "OPD DR VISITS-OTHER FED AMT-FAC 02";
label variable OPVSTL02 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 02";
label variable OPVWCP02 "OPD DR VISITS-WORKERS COMP AMT-FAC 02";
label variable OPVOPR02 "OPD DR VISITS - OTH PRIVATE AMT-FAC 02";
label variable OPVOPU02 "OPD DR VISITS-OTH PUBLIC AMT-FAC 02";
label variable OPVOSR02 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 02";
label variable OPSEXP02 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 02";
label variable OPSTCH02 "OPD PHYSICIAN VISIT CHARGES - DR 02";
label variable OPSSLF02 "OPD DR VISITS-SELF/FAMILY AMT-DR 02";
label variable OPSMCR02 "OPD DR VISITS-MEDICARE AMT-DR 02";
label variable OPSMCD02 "OPD DR VISITS-MEDICAID AMT-DR 02";
label variable OPSPRV02 "OPD DR VISITS-PRIV INS AMT-DR 02";
label variable OPSVA02 "OPD DR VISITS-VA AMT-DR 02";
label variable OPSTRI02 "OPD DR VISITS-TRICARE AMT-DR 02";
label variable OPSOFD02 "OPD DR VISITS-OTHER FED AMT-DR 02";
label variable OPSSTL02 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 02";
label variable OPSWCP02 "OPD DR VISITS-WORKERS COMP AMT-DR 02";
label variable OPSOPR02 "OPD DR VISITS - OTH PRIVATE AMT-DR 02";
label variable OPSOPU02 "OPD DR VISITS-OTH PUBLIC AMT-DR 02";
label variable OPSOSR02 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 02";
label variable OPOTHV02 "# OUTPATIENT DEPT NON-DR VISITS 02";
label variable OPOTCH02 "OPD NON-PHYS VISIT CHARGES - FAC 02";
label variable OPOEXP02 "TOTAL OUTPATIENT NON-DR - FAC EXP 02";
label variable OPOSLF02 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 02";
label variable OPOMCR02 "OPD NON-DR VISITS-MEDICARE AMT-FAC 02";
label variable OPOMCD02 "OPD NON-DR VISITS-MEDICAID AMT-FAC 02";
label variable OPOPRV02 "OPD NON-DR VISITS-PRIV INS AMT-FAC 02";
label variable OPOVA02 "OPD NON-DR VISITS-VA AMT-FAC 02";
label variable OPOTRI02 "OPD NON-DR VISITS-TRICARE AMT-FAC 02";
label variable OPOOFD02 "OPD NON-DR VISITS-OTHER FED AMT-FAC 02";
label variable OPOSTL02 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 02";
label variable OPOWCP02 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 02";
label variable OPOOPR02 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 02";
label variable OPOOPU02 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 02";
label variable OPOOSR02 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 02";
label variable OPPEXP02 "TOTAL OUTPATIENT NON-DR - DR EXP 02";
label variable OPPTCH02 "OPD NON-PHYS VISIT CHARGES - DR 02";
label variable OPPSLF02 "OPD NON-DR VISITS-SELF/FAM AMT-DR 02";
label variable OPPMCR02 "OPD NON-DR VISITS-MEDICARE AMT-DR 02";
label variable OPPMCD02 "OPD NON-DR VISITS-MEDICAID AMT-DR 02";
label variable OPPPRV02 "OPD NON-DR VISITS-PRIV INS AMT-DR 02";
label variable OPPVA02 "OPD NON-DR VISITS-VA AMT-DR 02";
label variable OPPTRI02 "OPD NON-DR VISITS-TRICARE AMT-DR 02";
label variable OPPOFD02 "OPD NON-DR VISITS-OTHER FED AMT-DR 02";
label variable OPPSTL02 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 02";
label variable OPPWCP02 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 02";
label variable OPPOPR02 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 02";
label variable OPPOPU02 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 02";
label variable OPPOSR02 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 02";
label variable AMCHIR02 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2002";
label variable AMCTCH02 "CHIRO AMBULATORY VISIT CHARGES 02";
label variable AMCEXP02 "TOTL AMBULTRY (OB+OP) CHIRO EXP 02";
label variable AMCSLF02 "CHIRO AMB VISITS -SELF/FAMILY AMT 02";
label variable AMCMCR02 "CHIRO AMB VISITS -MEDICARE AMT 02";
label variable AMCMCD02 "CHIRO AMB VISITS -MEDICAID AMT 02";
label variable AMCPRV02 "CHIRO AMB VISITS -PRIVATE INS AMT 02";
label variable AMCVA02 "CHIRO AMB VISITS -VA AMT 02";
label variable AMCTRI02 "CHIRO AMB VISITS-TRICARE AMT 02";
label variable AMCOFD02 "CHIRO AMB VISITS -OTHER FEDERAL AMT 02";
label variable AMCSTL02 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 02";
label variable AMCWCP02 "CHIRO AMB VISITS-WORKERS COMP AMT 02";
label variable AMCOPR02 "CHIRO AMB VISITS - OTH PRIVATE AMT 02";
label variable AMCOPU02 "CHIRO AMB VISITS - OTH PUBLIC AMT 02";
label variable AMCOSR02 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 02";
label variable AMNURS02 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 02";
label variable AMNTCH02 "NRS/PRAC AMBULATORY VISIT CHARGES 02";
label variable AMNEXP02 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 02";
label variable AMNSLF02 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 02";
label variable AMNMCR02 "NRS/PRAC AMB VSTS -MEDICARE AMT 02";
label variable AMNMCD02 "NRS/PRAC AMB VSTS -MEDICAID AMT 02";
label variable AMNPRV02 "NRS/PRAC AMB VSTS -PRIV INS AMT 02";
label variable AMNVA02 "NRS/PRAC AMB VSTS-VA AMT 02";
label variable AMNTRI02 "NRS/PRAC AMB VSTS-TRICARE AMT 02";
label variable AMNOFD02 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 02";
label variable AMNSTL02 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 02";
label variable AMNWCP02 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 02";
label variable AMNOPR02 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 02";
label variable AMNOPU02 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 02";
label variable AMNOSR02 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 02";
label variable AMOPTO02 "# AMB OPTOMETRIST VSTS (OB+OP) 02";
label variable AMETCH02 "OPTOMETRIST AMBULATORY VISIT CHARGES 02";
label variable AMEEXP02 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 02";
label variable AMESLF02 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 02";
label variable AMEMCR02 "OPTMTRIST AMB VSTS -MEDICARE AMT 02";
label variable AMEMCD02 "OPTMTRIST AMB VSTS -MEDICAID AMT 02";
label variable AMEPRV02 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 02";
label variable AMEVA02 "OPTMTRIST AMB VSTS-VA AMT 02";
label variable AMETRI02 "OPTMTRIST AMB VSTS-TRICARE AMT 02";
label variable AMEOFD02 "OPTMTRIST AMB VSTS-OTHER FED AMT 02";
label variable AMESTL02 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 02";
label variable AMEWCP02 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 02";
label variable AMEOPR02 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 02";
label variable AMEOPU02 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 02";
label variable AMEOSR02 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 02";
label variable AMASST02 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2002";
label variable AMATCH02 "PHYS ASS T AMBULATORY VISIT CHARGES 02";
label variable AMAEXP02 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 02";
label variable AMASLF02 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 02";
label variable AMAMCR02 "PHYS ASS T AMB VSTS-MEDICARE AMT 02";
label variable AMAMCD02 "PHYS ASS T AMB VSTS-MEDICAID AMT 02";
label variable AMAPRV02 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 02";
label variable AMAVA02 "PHYS ASS T AMB VSTS-VA AMT 02";
label variable AMATRI02 "PHYS ASS T AMB VSTS-TRICARE AMT 02";
label variable AMAOFD02 "PHYS ASS T AMB VSTS -OTHER FED AMT 02";
label variable AMASTL02 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 02";
label variable AMAWCP02 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 02";
label variable AMAOPR02 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 02";
label variable AMAOPU02 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 02";
label variable AMAOSR02 "P A AMB VSTS- OTH UNCLASS SRCE AMT 02";
label variable AMTHER02 "# AMB PT/OT THRPY VISITS (OB+OP) 02";
label variable AMTTCH02 "PT/OC AMBULATORY VISIT CHARGES 02";
label variable AMTEXP02 "TOTL AMBULTRY (OB+OP) PT/OT EXP 02";
label variable AMTSLF02 "PT/OT AMB VISITS-SELF/FAMILY AMT 02";
label variable AMTMCR02 "PT/OT AMB VISITS-MEDICARE AMT 02";
label variable AMTMCD02 "PT/OT AMB VISITS-MEDICAID AMT 02";
label variable AMTPRV02 "PT/OT AMB VISITS-PRIVATE INS AMT 02";
label variable AMTVA02 "PT/OT AMB VISITS-VA AMT 02";
label variable AMTTRI02 "PT/OT AMB VISITS-TRICARE AMT 02";
label variable AMTOFD02 "PT/OT AMB VISITS -OTHER FED AMT 02";
label variable AMTSTL02 "PT/OT AMB VISITS-OTH ST/LOCL AMT 02";
label variable AMTWCP02 "PT/OT AMB VISITS-WORKERS COMP AMT 02";
label variable AMTOPR02 "PT/OT AMB VISITS - OTH PRIVATE AMT 02";
label variable AMTOPU02 "PT/OT AMB VISITS-OTH PUBLIC AMT 02";
label variable AMTOSR02 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 02";
label variable AMTOTC02 "# CALLS W/OFFICE & OUPAT DEPTS, 2002";
label variable AMDRC02 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2002";
label variable ERTOT02 "# EMERGENCY ROOM VISITS 02";
label variable ERFTCH02 "ER FACILITY VISIT CHARGES 02";
label variable ERFEXP02 "TOTAL ER FACILITY EXP 02";
label variable ERFSLF02 "ER-SELF/FAMILY AMT - FAC 02";
label variable ERFMCR02 "ER-MEDICARE AMT - FAC 02";
label variable ERFMCD02 "ER-MEDICAID AMT - FAC 02";
label variable ERFPRV02 "ER-PRIVATE INS AMT - FAC 02";
label variable ERFVA02 "ER-VA AMT - FAC 02";
label variable ERFTRI02 "ER-TRICARE AMT - FAC 02";
label variable ERFOFD02 "ER-OTHER FEDERAL AMT - FAC 02";
label variable ERFSTL02 "ER-OTH ST/LOCAL AMT - FAC 02";
label variable ERFWCP02 "ER-WORKERS COMP AMT - FAC 02";
label variable ERFOPR02 "ER-OTHER PRIVATE AMT - FAC 02";
label variable ERFOPU02 "ER-OTHER PUBLIC AMT - FAC 02";
label variable ERFOSR02 "ER-OTH UNCLASS SRCE AMT - FAC 02";
label variable ERDEXP02 "TOTAL EMERGENCY ROOM DR EXP 02";
label variable ERDTCH02 "ER DOCTOR VISIT CHARGES 02";
label variable ERDSLF02 "ER-SELF/FAMILY AMT - DR 02";
label variable ERDMCR02 "ER-MEDICARE AMT - DR 02";
label variable ERDMCD02 "ER-MEDICAID AMT - DR 02";
label variable ERDPRV02 "ER-PRIVATE INS AMT - DR 02";
label variable ERDVA02 "ER-VA AMT - DR 02";
label variable ERDTRI02 "ER-TRICARE AMT - DR 02";
label variable ERDOFD02 "ER-OTHER FED AMT - DR 02";
label variable ERDSTL02 "ER-OTH ST/LOCAL AMT - DR 02";
label variable ERDWCP02 "ER-WORKERS COMP AMT - DR 02";
label variable ERDOPR02 "ER - OTHER PRIVATE AMT - DR 02";
label variable ERDOPU02 "ER - OTHER PUBLIC AMT - DR 02";
label variable ERDOSR02 "ER-OTH UNCLASS SRCE AMT - DR 02";
label variable IPZERO02 "# ZERO-NIGHT HOSPITAL STAYS 02";
label variable ZIFTCH02 "ZERO-NITE IP STAY CHARGES - FAC 02";
label variable ZIFEXP02 "TOTAL ZERO-NITE STAYS FAC EXP 02";
label variable ZIFSLF02 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 02";
label variable ZIFMCR02 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 02";
label variable ZIFMCD02 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 02";
label variable ZIFPRV02 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 02";
label variable ZIFVA02 "ZERO-NITE IP STAZ-VA AMT-FAC 02";
label variable ZIFTRI02 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 02";
label variable ZIFOFD02 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 02";
label variable ZIFSTL02 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 02";
label variable ZIFWCP02 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 02";
label variable ZIFOPR02 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 02";
label variable ZIFOPU02 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 02";
label variable ZIFOSR02 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 02";
label variable ZIDEXP02 "TOTAL ZERO-NITE STAZ DR 02";
label variable ZIDTCH02 "ZERO-NITE IP STAY CHARGES - DR 02";
label variable ZIDSLF02 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 02";
label variable ZIDMCR02 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 02";
label variable ZIDMCD02 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 02";
label variable ZIDPRV02 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 02";
label variable ZIDVA02 "ZERO-NITE IP STAZ-VA AMT-DR 02";
label variable ZIDTRI02 "ZERO-NITE IP STAZ-TRICARE AMT-DR 02";
label variable ZIDOFD02 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 02";
label variable ZIDSTL02 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 02";
label variable ZIDWCP02 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 02";
label variable ZIDOPR02 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 02";
label variable ZIDOPU02 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 02";
label variable ZIDOSR02 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 02";
label variable IPDIS02 "# HOSPITAL DISCHARGES, 2002";
label variable IPFEXP02 "TOT HOSP IP FACILITY EXP-INC 0 NITES 02";
label variable IPFTCH02 "IP HOSP STAY CHARGES - FAC 02";
label variable IPFSLF02 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 02";
label variable IPFMCR02 "IP HOSP STAZ-MEDICARE AMT-FAC 02";
label variable IPFMCD02 "IP HOSP STAZ-MEDICAID AMT-FAC 02";
label variable IPFPRV02 "IP HOSP STAZ-PRIV INS AMT-FAC 02";
label variable IPFVA02 "IP HOSP STAZ-VA AMT-FAC 02";
label variable IPFTRI02 "IP HOSP STAZ-TRICARE AMT-FAC 02";
label variable IPFOFD02 "IP HOSP STAZ-OTHER FED AMT-FAC 02";
label variable IPFSTL02 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 02";
label variable IPFWCP02 "IP HOSP STAZ-WORKERS COMP AMT-FAC 02";
label variable IPFOPR02 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 02";
label variable IPFOPU02 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 02";
label variable IPFOSR02 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 02";
label variable IPDEXP02 "TOTL HOSP STAZ DR EXP 02";
label variable IPDTCH02 "IP HOSP STAY CHARGES - DR 02";
label variable IPDSLF02 "IP HOSP STAZ-SELF/FAMILY AMT-DR 02";
label variable IPDMCR02 "IP HOSP STAZ-MEDICARE AMT- DR 02";
label variable IPDMCD02 "IP HOSP STAZ-MEDICAID AMT-DR 02";
label variable IPDPRV02 "IP HOSP STAZ-PRIV INS AMT- DR 02";
label variable IPDVA02 "IP HOSP STAZ-VA AMT-DR 02";
label variable IPDTRI02 "IP HOSP STAZ-TRICARE AMT-DR 02";
label variable IPDOFD02 "IP HOSP STAZ-OTHER FED AMT-DR 02";
label variable IPDSTL02 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 02";
label variable IPDWCP02 "IP HOSP STAZ-WORKERS COMP AMT-DR 02";
label variable IPDOPR02 "IP HOSP STAZ - OTH PRIVATE AMT-DR 02";
label variable IPDOPU02 "IP HOSP STAZ - OTH PUBLIC AMT-DR 02";
label variable IPDOSR02 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 02";
label variable IPNGTD02 "# NIGHTS IN HOSP FOR DISCHARGES, 2002";
label variable DVTOT02 "# DENTAL CARE VISITS 02";
label variable DVTTCH02 "TOTAL DENTAL CARE VISIT CHARGES 02";
label variable DVTEXP02 "TOTAL DENTAL CARE EXP 02";
label variable DVTSLF02 "ALL DENTAL CARE -SELF/FAMILY AMT 02";
label variable DVTMCR02 "ALL DENTAL CARE -MEDICARE AMT 02";
label variable DVTMCD02 "ALL DENTAL CARE -MEDICAID AMT 02";
label variable DVTPRV02 "ALL DENTAL CARE -PRIVATE INS AMT 02";
label variable DVTVA02 "ALL DENTAL CARE -VA AMT 02";
label variable DVTTRI02 "ALL DENTAL CARE -TRICARE AMT 02";
label variable DVTOFD02 "ALL DENTAL CARE -OTHER FEDRL AMT 02";
label variable DVTSTL02 "ALL DENTAL CARE -OTH ST/LOCAL AMT 02";
label variable DVTWCP02 "ALL DENTAL CARE -WORKERS COMP AMT 02";
label variable DVTOPR02 "ALL DENTAL CARE - OTH PRIVATE AMT 02";
label variable DVTOPU02 "ALL DENTAL CARE - OTH PUBLIC AMT 02";
label variable DVTOSR02 "ALL DENT CARE-OT UNCLASS SRCE AMT 02";
label variable DVGEN02 "# GENERAL DENTIST VISITS 02";
label variable DVGTCH02 "GENERAL DENTAL CARE VISIT CHARGES 02";
label variable DVGEXP02 "TOTAL GENERAL DENTIST EXP 02";
label variable DVGSLF02 "GNRL DENTAL VISITS -SELF/FAM AMT 02";
label variable DVGMCR02 "GNRL DENTAL VISITS -MEDICARE AMT 02";
label variable DVGMCD02 "GNRL DENTAL VISITS -MEDICAID AMT 02";
label variable DVGPRV02 "GNRL DENTAL VISITS -PRIVATE INS AMT 02";
label variable DVGVA02 "GNRL DENTAL VISITS -VA AMT 02";
label variable DVGTRI02 "GNRL DENTAL VISITS-TRICARE AMT 02";
label variable DVGOFD02 "GNRL DENTAL VISITS- OTHER FED AMT 02";
label variable DVGSTL02 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 02";
label variable DVGWCP02 "GNRL DENTAL VISITS - WORKERS COMP AMT 02";
label variable DVGOPR02 "GNRL DENTAL VISITS - OTH PRIVATE AMT 02";
label variable DVGOPU02 "GNRL DENTAL VISITS - OTH PUBLIC AMT 02";
label variable DVGOSR02 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 02";
label variable DVORTH02 "# ORTHODONTIST VISITS 02";
label variable DVOTCH02 "ORTHODONTIST VISIT CHARGES 02";
label variable DVOEXP02 "TOTAL ORTHODONTIST EXP 02";
label variable DVOSLF02 "ORTHODONTIST VISITS -SELF/FAMILY AMT 02";
label variable DVOMCR02 "ORTHODONTIST VISITS -MEDICARE AMT 02";
label variable DVOMCD02 "ORTHODONTIST VISITS -MEDICAID AMT 02";
label variable DVOPRV02 "ORTHODONTIST VISITS -PRIVATE INS AMT 02";
label variable DVOVA02 "ORTHODONTIST VISITS-VA AMT 02";
label variable DVOTRI02 "ORTHODONTIST VISITS-TRICARE AMT 02";
label variable DVOOFD02 "ORTHODONTIST VISITS-OTHR FED AMT 02";
label variable DVOSTL02 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 02";
label variable DVOWCP02 "ORTHODONTIST VISITS-WORKERS COMP AMT 02";
label variable DVOOPR02 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 02";
label variable DVOOPU02 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 02";
label variable DVOOSR02 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 02";
label variable HHTOTD02 "# HOME HEALTH PROVIDER DAYS, 2002";
label variable HHAGD02 "# AGENCY HOME HEALTH PROVIDER DAYS 02";
label variable HHATCH02 "HOME HEALTH AGENCY VISIT CHARGES 02";
label variable HHAEXP02 "TOTAL HOME HEALTH AGENCY EXP 02";
label variable HHASLF02 "HOME HLTH AGENCY -SELF/FAMILY AMT 02";
label variable HHAMCR02 "HOME HLTH AGENCY -MEDICARE AMT 02";
label variable HHAMCD02 "HOME HLTH AGENCY -MEDICAID AMT 02";
label variable HHAPRV02 "HOME HLTH AGENCY -PRIVATE INS AMT 02";
label variable HHAVA02 "HOME HLTH AGENCY-VA AMT 02";
label variable HHATRI02 "HOME HLTH AGENCY-TRICARE AMT 02";
label variable HHAOFD02 "HOME HLTH AGENCY-OTHER FED AMT 02";
label variable HHASTL02 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 02";
label variable HHAWCP02 "HOME HLTH AGENCY- WORKERS COMP AMT 02";
label variable HHAOPR02 "HOME HLTH AGENCY - OTH PRIVATE AMT 02";
label variable HHAOPU02 "HOME HLTH AGENCY - OTH PUBLIC AMT 02";
label variable HHAOSR02 "H HLTH AGENCY - OT UNCLASS SRCE AMT 02";
label variable HHINDD02 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 02";
label variable HHNTCH02 "HOME HEALTH NON-AGENCY VISIT CHARGES 02";
label variable HHNEXP02 "TOTAL HOME HEALTH NON-AGNCY EXP 02";
label variable HHNSLF02 "HOME HLTH NON-AGNCY -SELF/FAM AMT 02";
label variable HHNMCR02 "HOME HLTH NON-AGNCY -MEDICARE AMT 02";
label variable HHNMCD02 "HOME HLTH NON-AGNCY -MEDICAID AMT 02";
label variable HHNPRV02 "HOME HLTH NON-AGNCY -PRIV INS AMT 02";
label variable HHNVA02 "HOME HLTH NON-AGNCY-VA AMT 02";
label variable HHNTRI02 "HOME HLTH NON-AGNCY-TRICARE AMT 02";
label variable HHNOFD02 "HOME HLTH NON-AGNCY-OTHR FED AMT 02";
label variable HHNSTL02 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 02";
label variable HHNWCP02 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 02";
label variable HHNOPR02 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 02";
label variable HHNOPU02 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 02";
label variable HHNOSR02 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 02";
label variable HHINFD02 "# INFORMAL HOME HEALTH PROVIDER DAYS 02";
label variable VISEXP02 "TOTAL GLASSES/CONTACT LENS EXP 02";
label variable VISTCH02 "GLASSES/CONTACT LENSES CHARGES 02";
label variable VISSLF02 "GLASSES/CNTCT LENSES -SELF/FAM AMT 02";
label variable VISMCR02 "GLASSES/CNTCT LENSES-MEDICARE AMT 02";
label variable VISMCD02 "GLASSES/CNTCT LENSES-MEDICAID AMT 02";
label variable VISPRV02 "GLASSES/CNTCT LENSES-PRIV INS AMT 02";
label variable VISVA02 "GLASSES/CNTCT LENSES-VA AMT 02";
label variable VISTRI02 "GLASSES/LENSES-TRICARE AMT 02";
label variable VISOFD02 "GLASSES/CNTCT LENSES-OTHR FED AMT 02";
label variable VISSTL02 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 02";
label variable VISWCP02 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 02";
label variable VISOPR02 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 02";
label variable VISOPU02 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 02";
label variable VISOSR02 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 02";
label variable OTHTCH02 "OTHER EQUP/SUPPLIES CHARGES 02";
label variable OTHEXP02 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 02";
label variable OTHSLF02 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 02";
label variable OTHMCR02 "OTHER EQUP/SUPPLIES-MEDICARE AMT 02";
label variable OTHMCD02 "OTHER EQUP/SUPPLIES-MEDICAID AMT 02";
label variable OTHPRV02 "OTHER EQUP/SUPPLIES-PRIV INS AMT 02";
label variable OTHVA02 "OTHER EQUP/SUPPLY-VA AMT 02";
label variable OTHTRI02 "OTHER EQUP/SUPPLY-TRICARE AMT 02";
label variable OTHOFD02 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 02";
label variable OTHSTL02 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 02";
label variable OTHWCP02 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 02";
label variable OTHOPR02 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 02";
label variable OTHOPU02 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 02";
label variable OTHOSR02 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 02";
label variable RXTOT02 "# PRESC MEDS INCL REFILLS 02";
label variable RXEXP02 "TOTAL RX-EXP 02";
label variable RXSLF02 "TOTAL RX-SELF/FAMILY AMT 02";
label variable RXMCR02 "TOTAL RX--MEDICARE AMT 02";
label variable RXMCD02 "TOTAL RX-MEDICAID AMT 02";
label variable RXPRV02 "TOTAL RX-PRIVATE INS AMT 02";
label variable RXVA02 "TOTAL RX-VA AMT 02";
label variable RXTRI02 "TOTAL RX-TRICARE AMT 02";
label variable RXOFD02 "TOTAL RX-OTHER FED AMT 02";
label variable RXSTL02 "TOTAL RX-OTHER ST/LOCAL AMT 02";
label variable RXWCP02 "TOTAL RX-WORKERS COMP AMT 02";
label variable RXOPR02 "TOTAL RX - OTH PRIVATE AMT 02";
label variable RXOPU02 "TOTAL RX - OTH PUBLIC AMT 02";
label variable RXOSR02 "TOT RX-OTH UNCLASS SRCE AMT 02";
label variable PERWT02F "FINAL PERSON WEIGHT, 2002";
label variable FAMWT02F "FINAL FAMILY WEIGHT, 2002";
label variable FAMWT02C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/02";
label variable SAQWT02F "FINAL SAQ PERSON WEIGHT, 2002";
label variable DIABW02F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2002";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2002";


*DEFINE VALUE LABELS FOR REPORTS;
label define H700001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H700002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H700003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H700004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H700005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO PERFORM ACTIVITIES" ;

label define H700008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H700009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H700010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H700011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H700012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H700016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT ANXIOUS/DEPRESSED"
         2 "2 MODERATELY ANXIOUS/DEPRESSED"
         3 "3 EXTREMELY ANXIOUS/DEPRESSED" ;

label define H700017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H700021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H700022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H700025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H700026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700029X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H700030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 CONFINED TO BED" ;

label define H700037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H700040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H700042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PAIN"
         2 "2 HAVE MODERATE PAIN"
         3 "3 HAVE EXTREME PAIN" ;

label define H700043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H700044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H700048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H700050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH"
         100 "100 BEST HEALTH" ;

label define H700053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO WASH/DRESS" ;

label define H700054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H700056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H700059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H700060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700062X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H700063X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700064X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700065X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700066X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700067X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700068X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700069X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         45 "$45" ;

label define H700070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700071X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700072X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700073X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700074X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700075X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700076X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700077X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700078X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700079X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700080X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700082X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700083X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700086X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700087X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700088X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700089X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700090X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700091X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700092X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700093X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700094X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700095X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700096X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700097X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700098X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700099X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         104 "$105 - $104" ;

label define H700100X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700101X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700102X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700103X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700104X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700105X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700106X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700107X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         55 "$55" ;

label define H700108X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700110X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700112X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700113X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700114X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700115X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700117X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700118X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700119X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700121X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700122X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700123X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700124X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700125X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700126X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700127X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700128X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700129X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700130X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700131X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700132X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700133X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700134X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2750 "$2751 - $2750" ;

label define H700135X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700136X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700137X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700138X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700140X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H700142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H700143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H700161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR" ;

label define H700162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR"
         2003 "2003 YEAR" ;

label define H700163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700167X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H700168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H700175X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H700176X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H700177X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H700178X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700179X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700180X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H700182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H700183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700188X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H700189X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H700190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H700191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700193X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700197X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H700198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700202X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700203X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H700222X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H700223X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H700224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H700228X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H700229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H700233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H700234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H700235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H700236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H700237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H700238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H700239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H700240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H700241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H700243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H700244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H700246X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H700250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H700251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700252X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H700254X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700255X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H700256X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H700257X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H700258X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700259X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H700260X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H700264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H700267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700269X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700270X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H700271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H700272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H700274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H700275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700287X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700288X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700289X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700290X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700291X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700292X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700293X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700294X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700295X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700296X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700297X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700298X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700299X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700300X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700301X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700302X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700303X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700304X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700305X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         113 "$113" ;

label define H700306X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700307X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700308X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700309X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700311X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700312X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700313X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700314X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700315X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700316X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700317X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700318X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700319X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700320X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700321X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700322X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700323X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700325X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700326X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700327X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700328X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700329X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700330X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700331X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H700334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H700335X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H700336X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H700337X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H700338X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H700339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H700341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H700342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H700343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H700351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR" ;

label define H700352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H700353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR" ;

label define H700354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR"
         2003 "2003 YEAR" ;

label define H700355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700356X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H700357X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700358X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700359X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700360X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         60 "$60" ;

label define H700361X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700362X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700363X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700364X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700365X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700366X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700367X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700368X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700369X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700370X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700371X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700372X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700373X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700374X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700375X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700376X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700377X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700378X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700379X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700380X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700381X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700382X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700383X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700384X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700390X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H700391X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H700392X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H700393X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H700394X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H700395X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700396X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700397X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H700398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H700400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H700401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700402X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H700403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700405X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700408X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H700410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H700411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H700412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H700413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H700414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H700415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H700416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H700417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700419X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700423X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H700424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700429X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700431X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700432X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700433X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700434X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700435X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700436X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700437X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700440X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700441X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700442X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700443X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700446X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700447X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700448X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700449X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700450X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700451X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700452X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         109 "$109" ;

label define H700453X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700454X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700455X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700456X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700457X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700458X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         90 "$90" ;

label define H700459X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H700463X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H700464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H700465X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H700466X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700467X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700468X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700469X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700542X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H700543X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H700544X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H700545X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= 61.98"
         -9 "-9 NOT ASCERTAINED" ;

label define H700546X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= 61.98"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H700547X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= 61.98"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H700548X
         0 "0 NO"
         1 "1 YES" ;

label define H700549X
         0 "0 NO"
         1 "1 YES" ;

label define H700550X
         0 "0 NO"
         1 "1 YES" ;

label define H700551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700561X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H700562X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H700563X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H700564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700574X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2002"
         2 "2 NOT IN-SCOPE ON 12/31/2002" ;

label define H700575X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/02"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H700576X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/02"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H700577X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/02"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H700578X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/02"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H700579X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2002"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2002" ;

label define H700580X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H700581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700582X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700583X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700592X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700594X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H700595X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700596X
         -1 "-1 INAPPLICABLE"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H700597X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700598X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700599X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700600X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700601X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700602X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700603X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700604X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700605X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700606X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700607X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700608X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700610X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700611X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700612X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700613X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700614X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700615X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700616X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700617X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700618X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700619X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700620X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700621X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700622X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700623X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700624X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700625X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700628X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H700629X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700630X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700631X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H700632X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H700633X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H700634X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700636X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700637X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H700638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700639X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700640X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H700641X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700644X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700645X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700646X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H700648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H700649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H700651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H700652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H700653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H700654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H700655X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700657X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700658X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700659X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700660X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700661X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700662X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700663X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H700682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700684X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700685X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700686X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700696X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700697X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H700698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700712X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H700713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700732X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700733X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700734X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H700735X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700736X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H700737X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H700738X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H700739X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700740X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H700741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H700745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H700747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H700748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H700749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700751X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700752X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H700755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H700756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H700757X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H700758X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H700759X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H700760X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H700761X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H700764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H700765X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700766X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700768X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700769X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H700773X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700774X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700777X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700778X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H700779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H700780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H700781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H700782X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700783X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700784X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700785X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700786X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         45 "$45" ;

label define H700788X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700789X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700790X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700792X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700793X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700794X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700795X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700796X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700797X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700798X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700799X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700800X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700801X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700802X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700803X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700804X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700805X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700806X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700807X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700808X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700809X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700810X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700811X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700812X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700813X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700814X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700815X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700816X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700817X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700818X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700819X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700821X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700822X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700823X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700824X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700825X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700826X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700827X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700828X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700829X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700830X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700831X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700832X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700833X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700834X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700835X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700836X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700837X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700838X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700839X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700840X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         55 "$55" ;

label define H700841X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700842X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700843X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700844X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700845X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700846X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700847X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700848X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700849X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700850X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700851X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700852X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700854X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700855X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700856X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700857X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700858X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700859X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700860X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700861X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700862X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700863X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700865X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700866X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700867X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700869X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700870X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700872X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700874X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700875X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700876X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700877X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700878X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         885 "$885" ;

label define H700879X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700881X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700882X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700883X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700884X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700885X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700886X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700887X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700888X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700889X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700890X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700891X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700892X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700893X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700894X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700895X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700896X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700897X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700898X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700899X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700900X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700901X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700902X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H700903X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H700904X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H700905X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700906X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700907X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700908X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700909X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700910X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700913X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700914X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H700915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700918X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H700919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700931X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H700932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H700941X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700942X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700943X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700944X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         111 "$111" ;

label define H700945X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700946X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700947X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700948X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700949X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700950X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700951X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700952X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700953X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700954X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700955X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700956X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700957X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700958X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700959X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700960X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700961X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700962X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700963X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700964X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700965X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700966X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700967X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700968X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700969X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700970X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700971X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700972X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700973X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700974X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700975X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700976X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700977X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700978X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700979X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700980X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700982X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700983X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700984X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700985X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700986X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700987X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700988X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         111 "$111" ;

label define H700989X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700990X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700991X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         133 "$133" ;

label define H700992X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700993X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700994X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700995X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700996X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700997X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700998X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H700999X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701000X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701001X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701002X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701003X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701004X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701005X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701006X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701007X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701008X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701009X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701010X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701011X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701012X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701014X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701015X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701016X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701017X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701018X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701019X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701020X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701021X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701022X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701023X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701024X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701025X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701026X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701027X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701031X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701032X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701033X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701034X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701035X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701039X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701040X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701041X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701042X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701043X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701045X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701046X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701047X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701048X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701049X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701050X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701051X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701052X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701066X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701067X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701070X
         6 "6 PANEL 6"
         7 "7 PANEL 7" ;

label define H701071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H701072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701073X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701074X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701076X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701077X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701083X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701099X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701103X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H701104X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701105X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701106X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701107X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H701108X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H701109X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H701110X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H701111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H701114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H701117X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H701121X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H701122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H701123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H701126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701162X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H701163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H701171X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H701172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H701173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H701174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701176X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701177X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701186X
         -1 "-1 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701220X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H701221X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H701222X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H701223X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H701224X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H701225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701226X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701227X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701228X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701229X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701230X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701237X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701238X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701239X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701241X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701242X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701246X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H701247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H701248X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H701249X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H701250X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H701251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701260X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701261X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701262X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701263X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701264X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701265X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701266X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701267X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701268X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701269X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701270X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701271X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701273X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H701274X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H701275X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H701276X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H701277X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H701278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701284X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701286X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701287X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H701288X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H701289X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H701290X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H701291X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H701292X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H701293X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H701294X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H701295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H701296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701297X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701298X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H701300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H701301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H701302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H701303X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H701304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H701305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H701306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H701307X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H701308X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H701309X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H701310X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H701311X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H701312X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H701313X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H701314X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H701315X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701316X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701317X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701318X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701319X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701320X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701321X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701322X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701323X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701324X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701325X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701326X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701327X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701328X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701330X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701331X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701332X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H701333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H701341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701342X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701344X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701345X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H701347X
         0 "0 NO"
         1 "1 YES" ;

label define H701348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H701350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701351X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701352X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701355X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H701356X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H701357X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H701358X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H701359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H701360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H701361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H701362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H701363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701365X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H701366X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABLILITY"
         2 "2 SOME OTHER REASON" ;

label define H701368X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701369X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H701371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H701372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H701373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701390X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701391X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H701393X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H701394X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H701395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701396X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701397X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H701398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H701403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H701404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H701410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H701411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H701412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H701413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H701419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H701421X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701422X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701423X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701424X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701425X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701426X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701427X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701428X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701429X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701430X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701431X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701432X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701433X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701434X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701435X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701441X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701450X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H701451X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H701452X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H701453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701457X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H701458X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H701459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701463X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H701464X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H701465X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H701466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H701467X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H701468X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H701469X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H701470X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701471X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701472X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701473X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         2 "2 MD - INTERNAL MEDICINE"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H701474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701476X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701477X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701478X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H701479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H701480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701481X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701482X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701484X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 - 4 YEARS"
         3 "3 5 - 9 YEARS"
         4 "4 10 - 15 YEARS"
         5 "5 15 YEARS OR MORE" ;

label define H701486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H701487X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H701489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H701490X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H701492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H701493X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H701495X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701496X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701497X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701498X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701499X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701500X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701501X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701502X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701503X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701504X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701505X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701506X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701507X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701508X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701509X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701523X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701524X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H701525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H701526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H701530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H701539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701545X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H701547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H701551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H701553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H701554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H701555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H701556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H701557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H701558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN-NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H701559X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701560X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701561X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701562X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701563X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701564X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701565X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701566X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701567X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701568X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701569X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701570X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701571X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701572X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701573X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701574X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701576X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701577X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701578X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         872 "$872" ;

label define H701579X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1828 "$1828" ;

label define H701580X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701581X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701582X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701583X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H701584X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         107 "$107" ;

label define H701585X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         30 "$30" ;

label define H701586X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H700001X;
label value ACTDTY31 H700002X;
label value ACTDTY42 H700003X;
label value ACTDTY53 H700004X;
label value ACTLIM31 H700005X;
label value ACTLIM53 H700006X;
label value ADACTI42 H700007X;
label value ADAPPT42 H700008X;
label value ADBLUE42 H700009X;
label value ADCALM42 H700010X;
label value ADCLIM42 H700011X;
label value ADCMPD42 H700012X;
label value ADCMPM42 H700013X;
label value ADCMPY42 H700014X;
label value ADDAYA42 H700015X;
label value ADDEPR42 H700016X;
label value ADDRBP42 H700017X;
label value ADDSMK42 H700018X;
label value ADEXPL42 H700019X;
label value ADGENH42 H700020X;
label value ADHECR42 H700021X;
label value ADILCR42 H700022X;
label value ADILWW42 H700023X;
label value ADINSA42 H700024X;
label value ADINSB42 H700025X;
label value ADL3MO31 H700026X;
label value ADL3MO42 H700027X;
label value ADL3MO53 H700028X;
label value ADLANG42 H700029X;
label value ADLHLP31 H700030X;
label value ADLHLP42 H700031X;
label value ADLHLP53 H700032X;
label value ADLIST42 H700033X;
label value ADMACC42 H700034X;
label value ADMLMT42 H700035X;
label value ADMOBI42 H700036X;
label value ADNDCR42 H700037X;
label value ADNECP42 H700038X;
label value ADOVER42 H700039X;
label value ADPACC42 H700040X;
label value ADPAIN42 H700041X;
label value ADPAYN42 H700042X;
label value ADPEP42 H700043X;
label value ADPLMT42 H700044X;
label value ADPRRE42 H700045X;
label value ADPRTM42 H700046X;
label value ADPRX42 H700047X;
label value ADRESP42 H700048X;
label value ADRISK42 H700049X;
label value ADRTCR42 H700050X;
label value ADRTWW42 H700051X;
label value ADSCAL42 H700052X;
label value ADSELF42 H700053X;
label value ADSMOK42 H700054X;
label value ADSOCA42 H700055X;
label value ADSPEC42 H700056X;
label value ADUPRO42 H700057X;
label value AFDC02 H700058X;
label value AFTHOU42 H700059X;
label value AIDHLP31 H700060X;
label value AIDHLP53 H700061X;
label value ALIIMP02 H700062X;
label value ALIMP02X H700063X;
label value AMAEXP02 H700064X;
label value AMAMCD02 H700065X;
label value AMAMCR02 H700066X;
label value AMAOFD02 H700067X;
label value AMAOPR02 H700068X;
label value AMAOPU02 H700069X;
label value AMAOSR02 H700070X;
label value AMAPRV02 H700071X;
label value AMASLF02 H700072X;
label value AMASST02 H700073X;
label value AMASTL02 H700074X;
label value AMATCH02 H700075X;
label value AMATRI02 H700076X;
label value AMAVA02 H700077X;
label value AMAWCP02 H700078X;
label value AMCEXP02 H700079X;
label value AMCHIR02 H700080X;
label value AMCMCD02 H700081X;
label value AMCMCR02 H700082X;
label value AMCOFD02 H700083X;
label value AMCOPR02 H700084X;
label value AMCOPU02 H700085X;
label value AMCOSR02 H700086X;
label value AMCPRV02 H700087X;
label value AMCSLF02 H700088X;
label value AMCSTL02 H700089X;
label value AMCTCH02 H700090X;
label value AMCTRI02 H700091X;
label value AMCVA02 H700092X;
label value AMCWCP02 H700093X;
label value AMEEXP02 H700094X;
label value AMEMCD02 H700095X;
label value AMEMCR02 H700096X;
label value AMEOFD02 H700097X;
label value AMEOPR02 H700098X;
label value AMEOPU02 H700099X;
label value AMEOSR02 H700100X;
label value AMEPRV02 H700101X;
label value AMESLF02 H700102X;
label value AMESTL02 H700103X;
label value AMETCH02 H700104X;
label value AMETRI02 H700105X;
label value AMEVA02 H700106X;
label value AMEWCP02 H700107X;
label value AMNEXP02 H700108X;
label value AMNMCD02 H700109X;
label value AMNMCR02 H700110X;
label value AMNOFD02 H700111X;
label value AMNOPR02 H700112X;
label value AMNOPU02 H700113X;
label value AMNOSR02 H700114X;
label value AMNPRV02 H700115X;
label value AMNSLF02 H700116X;
label value AMNSTL02 H700117X;
label value AMNTCH02 H700118X;
label value AMNTRI02 H700119X;
label value AMNURS02 H700120X;
label value AMNVA02 H700121X;
label value AMNWCP02 H700122X;
label value AMOPTO02 H700123X;
label value AMTEXP02 H700124X;
label value AMTHER02 H700125X;
label value AMTMCD02 H700126X;
label value AMTMCR02 H700127X;
label value AMTOFD02 H700128X;
label value AMTOPR02 H700129X;
label value AMTOPU02 H700130X;
label value AMTOSR02 H700131X;
label value AMTPRV02 H700132X;
label value AMTSLF02 H700133X;
label value AMTSTL02 H700134X;
label value AMTTCH02 H700135X;
label value AMTTRI02 H700136X;
label value AMTVA02 H700137X;
label value AMTWCP02 H700138X;
label value ANGIDX53 H700139X;
label value ANYLIM02 H700140X;
label value APRVDLYM H700141X;
label value APRVDLYT H700142X;
label value APRVTRTM H700143X;
label value APRVTRTT H700144X;
label value ARTHDX53 H700145X;
label value ARTHTX53 H700146X;
label value ASATAK53 H700147X;
label value ASFLOW53 H700148X;
label value ASIANP42 H700149X;
label value ASMED53 H700150X;
label value ASPRIN53 H700151X;
label value ASSTER53 H700152X;
label value ASTHDX53 H700153X;
label value BEGRFD31 H700154X;
label value BEGRFD42 H700155X;
label value BEGRFD53 H700156X;
label value BEGRFM31 H700157X;
label value BEGRFM42 H700158X;
label value BEGRFM53 H700159X;
label value BEGRFY31 H700160X;
label value BEGRFY42 H700161X;
label value BEGRFY53 H700162X;
label value BENDIF31 H700163X;
label value BENDIF53 H700164X;
label value BLCKPR42 H700165X;
label value BLIND42 H700166X;
label value BMINDX53 H700167X;
label value BOOST42 H700168X;
label value BOWEL53 H700169X;
label value BPCHEK53 H700170X;
label value BPMLDX53 H700171X;
label value BPMONT53 H700172X;
label value BRSTEX53 H700173X;
label value BSNTY31 H700174X;
label value BSNTY42 H700175X;
label value BSNTY53 H700176X;
label value BUSIMP02 H700177X;
label value BUSNP02X H700178X;
label value CARECO42 H700179X;
label value CASHP02X H700180X;
label value CHAPPT42 H700181X;
label value CHBMIX42 H700182X;
label value CHCOUN42 H700183X;
label value CHDDX53 H700184X;
label value CHECK53 H700185X;
label value CHEMPB42 H700186X;
label value CHEXPL42 H700187X;
label value CHGJ3142 H700188X;
label value CHGJ4253 H700189X;
label value CHHECR42 H700190X;
label value CHILCR42 H700191X;
label value CHILWW42 H700192X;
label value CHLDP02X H700193X;
label value CHLICO42 H700194X;
label value CHLIHB42 H700195X;
label value CHLIMI42 H700196X;
label value CHLIMP02 H700197X;
label value CHLIST42 H700198X;
label value CHNDCR42 H700199X;
label value CHNECP42 H700200X;
label value CHOIC31 H700201X;
label value CHOIC42 H700202X;
label value CHOIC53 H700203X;
label value CHOLCK53 H700204X;
label value CHPMCN42 H700205X;
label value CHPMED42 H700206X;
label value CHPMHB42 H700207X;
label value CHPRRE42 H700208X;
label value CHPRTM42 H700209X;
label value CHRESP42 H700210X;
label value CHRTCR42 H700211X;
label value CHRTWW42 H700212X;
label value CHSERV42 H700213X;
label value CHSPEC42 H700214X;
label value CHSRCN42 H700215X;
label value CHSRHB42 H700216X;
label value CHTHCO42 H700217X;
label value CHTHER42 H700218X;
label value CHTHHB42 H700219X;
label value CLMDEP02 H700220X;
label value CLMHIP02 H700221X;
label value COGLIM31 H700222X;
label value COGLIM53 H700223X;
label value CONTRL42 H700224X;
label value COVRMM H700225X;
label value COVRYY H700226X;
label value CSHCN42 H700227X;
label value CSHIMP02 H700228X;
label value CUSTSVCM H700229X;
label value CUSTSVCT H700230X;
label value DADPRO42 H700231X;
label value DDBDYS31 H700232X;
label value DDBDYS42 H700233X;
label value DDBDYS53 H700234X;
label value DDNSCL31 H700235X;
label value DDNSCL42 H700236X;
label value DDNSCL53 H700237X;
label value DDNWRK31 H700238X;
label value DDNWRK42 H700239X;
label value DDNWRK53 H700240X;
label value DEAF42 H700241X;
label value DECIDE42 H700242X;
label value DEDUCT02 H700243X;
label value DENTAL42 H700244X;
label value DENTCK53 H700245X;
label value DENTIN31 H700246X;
label value DENTIN42 H700247X;
label value DENTIN53 H700248X;
label value DEPDNT02 H700249X;
label value DFTOUS42 H700250X;
label value DIABDX53 H700251X;
label value DIABW02F H700252X;
label value DIDSERVE H700253X;
label value DIFFPL42 H700254X;
label value DISVW31X H700255X;
label value DISVW42X H700256X;
label value DISVW53X H700257X;
label value DIVDP02X H700258X;
label value DIVIMP02 H700259X;
label value DKWHRU42 H700260X;
label value DNDLAY42 H700261X;
label value DNDLPR42 H700262X;
label value DNDLRS42 H700263X;
label value DNUNAB42 H700264X;
label value DNUNPR42 H700265X;
label value DNUNRS42 H700266X;
label value DOBMM H700267X;
label value DOBYY H700268X;
label value DOCELS42 H700269X;
label value DPINRU02 H700270X;
label value DPOTSD02 H700271X;
label value DRTHRT53 H700272X;
label value DSA1C53 H700273X;
label value DSCKFT53 H700274X;
label value DSDIA53 H700275X;
label value DSDIET53 H700276X;
label value DSEB0153 H700277X;
label value DSEY0153 H700278X;
label value DSEY0253 H700279X;
label value DSEY0353 H700280X;
label value DSEYNV53 H700281X;
label value DSEYPR53 H700282X;
label value DSINSU53 H700283X;
label value DSKIDN53 H700284X;
label value DSMED53 H700285X;
label value DSPRX53 H700286X;
label value DVGEN02 H700287X;
label value DVGEXP02 H700288X;
label value DVGMCD02 H700289X;
label value DVGMCR02 H700290X;
label value DVGOFD02 H700291X;
label value DVGOPR02 H700292X;
label value DVGOPU02 H700293X;
label value DVGOSR02 H700294X;
label value DVGPRV02 H700295X;
label value DVGSLF02 H700296X;
label value DVGSTL02 H700297X;
label value DVGTCH02 H700298X;
label value DVGTRI02 H700299X;
label value DVGVA02 H700300X;
label value DVGWCP02 H700301X;
label value DVOEXP02 H700302X;
label value DVOMCD02 H700303X;
label value DVOMCR02 H700304X;
label value DVOOFD02 H700305X;
label value DVOOPR02 H700306X;
label value DVOOPU02 H700307X;
label value DVOOSR02 H700308X;
label value DVOPRV02 H700309X;
label value DVORTH02 H700310X;
label value DVOSLF02 H700311X;
label value DVOSTL02 H700312X;
label value DVOTCH02 H700313X;
label value DVOTRI02 H700314X;
label value DVOVA02 H700315X;
label value DVOWCP02 H700316X;
label value DVTEXP02 H700317X;
label value DVTMCD02 H700318X;
label value DVTMCR02 H700319X;
label value DVTOFD02 H700320X;
label value DVTOPR02 H700321X;
label value DVTOPU02 H700322X;
label value DVTOSR02 H700323X;
label value DVTOT02 H700324X;
label value DVTPRV02 H700325X;
label value DVTSLF02 H700326X;
label value DVTSTL02 H700327X;
label value DVTTCH02 H700328X;
label value DVTTRI02 H700329X;
label value DVTVA02 H700330X;
label value DVTWCP02 H700331X;
label value EATHLT42 H700332X;
label value EDUCYEAR H700333X;
label value EICRDT02 H700334X;
label value ELGRND02 H700335X;
label value ELGRND31 H700336X;
label value ELGRND42 H700337X;
label value ELGRND53 H700338X;
label value EMPHDX53 H700339X;
label value EMPST31 H700340X;
label value EMPST42 H700341X;
label value EMPST53 H700342X;
label value ENDRFD02 H700343X;
label value ENDRFD31 H700344X;
label value ENDRFD42 H700345X;
label value ENDRFD53 H700346X;
label value ENDRFM02 H700347X;
label value ENDRFM31 H700348X;
label value ENDRFM42 H700349X;
label value ENDRFM53 H700350X;
label value ENDRFY02 H700351X;
label value ENDRFY31 H700352X;
label value ENDRFY42 H700353X;
label value ENDRFY53 H700354X;
label value ENGSPK42 H700355X;
label value EQU42 H700356X;
label value ERDEXP02 H700357X;
label value ERDMCD02 H700358X;
label value ERDMCR02 H700359X;
label value ERDOFD02 H700360X;
label value ERDOPR02 H700361X;
label value ERDOPU02 H700362X;
label value ERDOSR02 H700363X;
label value ERDPRV02 H700364X;
label value ERDSLF02 H700365X;
label value ERDSTL02 H700366X;
label value ERDTCH02 H700367X;
label value ERDTRI02 H700368X;
label value ERDVA02 H700369X;
label value ERDWCP02 H700370X;
label value ERFEXP02 H700371X;
label value ERFMCD02 H700372X;
label value ERFMCR02 H700373X;
label value ERFOFD02 H700374X;
label value ERFOPR02 H700375X;
label value ERFOPU02 H700376X;
label value ERFOSR02 H700377X;
label value ERFPRV02 H700378X;
label value ERFSLF02 H700379X;
label value ERFSTL02 H700380X;
label value ERFTCH02 H700381X;
label value ERFTRI02 H700382X;
label value ERFVA02 H700383X;
label value ERFWCP02 H700384X;
label value EVRETIRE H700385X;
label value EVRWRK H700386X;
label value EXPLOP42 H700387X;
label value EXRCIS53 H700388X;
label value FACLPR42 H700389X;
label value FAMRFPYR H700390X;
label value FAMSZE02 H700391X;
label value FAMSZE31 H700392X;
label value FAMSZE42 H700393X;
label value FAMSZE53 H700394X;
label value FAMWT02C H700395X;
label value FAMWT02F H700396X;
label value FCRP1231 H700397X;
label value FILEDR02 H700398X;
label value FILER02 H700399X;
label value FLSTAT02 H700400X;
label value FLUSHT53 H700401X;
label value FMRS1231 H700402X;
label value FNGRDF31 H700403X;
label value FNGRDF53 H700404X;
label value FOODCT02 H700405X;
label value FOODMN02 H700406X;
label value FOODST02 H700407X;
label value FOODVL02 H700408X;
label value FTSTU02X H700409X;
label value FTSTU31X H700410X;
label value FTSTU42X H700411X;
label value FTSTU53X H700412X;
label value GENDRP42 H700413X;
label value GOTOUS42 H700414X;
label value GTDCPRBM H700415X;
label value GTDCPRBT H700416X;
label value HAVEUS42 H700417X;
label value HAVFUN42 H700418X;
label value HEALTH42 H700419X;
label value HEARAD42 H700420X;
label value HEARDI42 H700421X;
label value HEARMO42 H700422X;
label value HEARNG42 H700423X;
label value HEARSM42 H700424X;
label value HELD31X H700425X;
label value HELD42X H700426X;
label value HELD53X H700427X;
label value HELMET42 H700428X;
label value HHAEXP02 H700429X;
label value HHAGD02 H700430X;
label value HHAMCD02 H700431X;
label value HHAMCR02 H700432X;
label value HHAOFD02 H700433X;
label value HHAOPR02 H700434X;
label value HHAOPU02 H700435X;
label value HHAOSR02 H700436X;
label value HHAPRV02 H700437X;
label value HHASLF02 H700438X;
label value HHASTL02 H700439X;
label value HHATCH02 H700440X;
label value HHATRI02 H700441X;
label value HHAVA02 H700442X;
label value HHAWCP02 H700443X;
label value HHINDD02 H700444X;
label value HHINFD02 H700445X;
label value HHNEXP02 H700446X;
label value HHNMCD02 H700447X;
label value HHNMCR02 H700448X;
label value HHNOFD02 H700449X;
label value HHNOPR02 H700450X;
label value HHNOPU02 H700451X;
label value HHNOSR02 H700452X;
label value HHNPRV02 H700453X;
label value HHNSLF02 H700454X;
label value HHNSTL02 H700455X;
label value HHNTCH02 H700456X;
label value HHNTRI02 H700457X;
label value HHNVA02 H700458X;
label value HHNWCP02 H700459X;
label value HHTOTD02 H700460X;
label value HIBPDX53 H700461X;
label value HIDEGYR H700462X;
label value HISPANX H700463X;
label value HISPCAT H700464X;
label value HLTHLF42 H700465X;
label value HOMEBH42 H700466X;
label value HOUR31 H700467X;
label value HOUR42 H700468X;
label value HOUR53 H700469X;
label value HPDAP02 H700470X;
label value HPDAU02 H700471X;
label value HPDDE02 H700472X;
label value HPDFE02 H700473X;
label value HPDJA02 H700474X;
label value HPDJL02 H700475X;
label value HPDJU02 H700476X;
label value HPDMA02 H700477X;
label value HPDMY02 H700478X;
label value HPDNO02 H700479X;
label value HPDOC02 H700480X;
label value HPDSE02 H700481X;
label value HPEAP02 H700482X;
label value HPEAU02 H700483X;
label value HPEDE02 H700484X;
label value HPEFE02 H700485X;
label value HPEJA02 H700486X;
label value HPEJL02 H700487X;
label value HPEJU02 H700488X;
label value HPEMA02 H700489X;
label value HPEMY02 H700490X;
label value HPENO02 H700491X;
label value HPEOC02 H700492X;
label value HPESE02 H700493X;
label value HPNAP02 H700494X;
label value HPNAU02 H700495X;
label value HPNDE02 H700496X;
label value HPNFE02 H700497X;
label value HPNJA02 H700498X;
label value HPNJL02 H700499X;
label value HPNJU02 H700500X;
label value HPNMA02 H700501X;
label value HPNMY02 H700502X;
label value HPNNO02 H700503X;
label value HPNOC02 H700504X;
label value HPNSE02 H700505X;
label value HPOAP02 H700506X;
label value HPOAU02 H700507X;
label value HPODE02 H700508X;
label value HPOFE02 H700509X;
label value HPOJA02 H700510X;
label value HPOJL02 H700511X;
label value HPOJU02 H700512X;
label value HPOMA02 H700513X;
label value HPOMY02 H700514X;
label value HPONO02 H700515X;
label value HPOOC02 H700516X;
label value HPOSE02 H700517X;
label value HPRAP02 H700518X;
label value HPRAU02 H700519X;
label value HPRDE02 H700520X;
label value HPRFE02 H700521X;
label value HPRJA02 H700522X;
label value HPRJL02 H700523X;
label value HPRJU02 H700524X;
label value HPRMA02 H700525X;
label value HPRMY02 H700526X;
label value HPRNO02 H700527X;
label value HPROC02 H700528X;
label value HPRSE02 H700529X;
label value HPSAP02 H700530X;
label value HPSAU02 H700531X;
label value HPSDE02 H700532X;
label value HPSFE02 H700533X;
label value HPSJA02 H700534X;
label value HPSJL02 H700535X;
label value HPSJU02 H700536X;
label value HPSMA02 H700537X;
label value HPSMY02 H700538X;
label value HPSNO02 H700539X;
label value HPSOC02 H700540X;
label value HPSSE02 H700541X;
label value HRHOW31 H700542X;
label value HRHOW42 H700543X;
label value HRHOW53 H700544X;
label value HRWG31X H700545X;
label value HRWG42X H700546X;
label value HRWG53X H700547X;
label value HRWGIM31 H700548X;
label value HRWGIM42 H700549X;
label value HRWGIM53 H700550X;
label value HSELIM31 H700551X;
label value HSELIM53 H700552X;
label value HSPLAP42 H700553X;
label value HYSTER53 H700554X;
label value IADL3M31 H700555X;
label value IADL3M42 H700556X;
label value IADL3M53 H700557X;
label value IADLHP31 H700558X;
label value IADLHP42 H700559X;
label value IADLHP53 H700560X;
label value INDCAT31 H700561X;
label value INDCAT42 H700562X;
label value INDCAT53 H700563X;
label value INS02X H700564X;
label value INS31X H700565X;
label value INS42X H700566X;
label value INS53X H700567X;
label value INSAP02X H700568X;
label value INSAT02X H700569X;
label value INSAT31X H700570X;
label value INSAT42X H700571X;
label value INSAT53X H700572X;
label value INSAU02X H700573X;
label value INSC1231 H700574X;
label value INSCOP02 H700575X;
label value INSCOP31 H700576X;
label value INSCOP42 H700577X;
label value INSCOP53 H700578X;
label value INSCOPE H700579X;
label value INSCOV02 H700580X;
label value INSDE02X H700581X;
label value INSENDMM H700582X;
label value INSENDYY H700583X;
label value INSFE02X H700584X;
label value INSJA02X H700585X;
label value INSJL02X H700586X;
label value INSJU02X H700587X;
label value INSMA02X H700588X;
label value INSMY02X H700589X;
label value INSNO02X H700590X;
label value INSOC02X H700591X;
label value INSRPL42 H700592X;
label value INSSE02X H700593X;
label value INTIMP02 H700594X;
label value INTRP02X H700595X;
label value INTVLANG H700596X;
label value IPDEXP02 H700597X;
label value IPDIS02 H700598X;
label value IPDMCD02 H700599X;
label value IPDMCR02 H700600X;
label value IPDOFD02 H700601X;
label value IPDOPR02 H700602X;
label value IPDOPU02 H700603X;
label value IPDOSR02 H700604X;
label value IPDPRV02 H700605X;
label value IPDSLF02 H700606X;
label value IPDSTL02 H700607X;
label value IPDTCH02 H700608X;
label value IPDTRI02 H700609X;
label value IPDVA02 H700610X;
label value IPDWCP02 H700611X;
label value IPFEXP02 H700612X;
label value IPFMCD02 H700613X;
label value IPFMCR02 H700614X;
label value IPFOFD02 H700615X;
label value IPFOPR02 H700616X;
label value IPFOPU02 H700617X;
label value IPFOSR02 H700618X;
label value IPFPRV02 H700619X;
label value IPFSLF02 H700620X;
label value IPFSTL02 H700621X;
label value IPFTCH02 H700622X;
label value IPFTRI02 H700623X;
label value IPFVA02 H700624X;
label value IPFWCP02 H700625X;
label value IPNGTD02 H700626X;
label value IPZERO02 H700627X;
label value IRAIMP02 H700628X;
label value IRASP02X H700629X;
label value JNTPID02 H700630X;
label value JOBORG31 H700631X;
label value JOBORG42 H700632X;
label value JOBORG53 H700633X;
label value JOBRSN42 H700634X;
label value JTINRU02 H700635X;
label value JTPAIN53 H700636X;
label value KEYNESS H700637X;
label value KIDPRO42 H700638X;
label value KNOWDR42 H700639X;
label value LANGHM42 H700640X;
label value LANGPR42 H700641X;
label value LAPBLT42 H700642X;
label value LFTDIF31 H700643X;
label value LFTDIF53 H700644X;
label value LKINFOM H700645X;
label value LKINFOT H700646X;
label value LOCATN42 H700647X;
label value LSHLTH42 H700648X;
label value LSTETH53 H700649X;
label value MAMOGR53 H700650X;
label value MARRY02X H700651X;
label value MARRY31X H700652X;
label value MARRY42X H700653X;
label value MARRY53X H700654X;
label value MCAID02 H700655X;
label value MCAID02X H700656X;
label value MCAID31 H700657X;
label value MCAID31X H700658X;
label value MCAID42 H700659X;
label value MCAID42X H700660X;
label value MCAID53 H700661X;
label value MCAID53X H700662X;
label value MCARE02 H700663X;
label value MCARE02X H700664X;
label value MCARE31 H700665X;
label value MCARE31X H700666X;
label value MCARE42 H700667X;
label value MCARE42X H700668X;
label value MCARE53 H700669X;
label value MCARE53X H700670X;
label value MCDAP02 H700671X;
label value MCDAP02X H700672X;
label value MCDAT02X H700673X;
label value MCDAT31X H700674X;
label value MCDAT42X H700675X;
label value MCDAT53X H700676X;
label value MCDAU02 H700677X;
label value MCDAU02X H700678X;
label value MCDDE02 H700679X;
label value MCDDE02X H700680X;
label value MCDEV02 H700681X;
label value MCDFE02 H700682X;
label value MCDFE02X H700683X;
label value MCDHMO02 H700684X;
label value MCDHMO31 H700685X;
label value MCDHMO42 H700686X;
label value MCDJA02 H700687X;
label value MCDJA02X H700688X;
label value MCDJL02 H700689X;
label value MCDJL02X H700690X;
label value MCDJU02 H700691X;
label value MCDJU02X H700692X;
label value MCDMA02 H700693X;
label value MCDMA02X H700694X;
label value MCDMC02 H700695X;
label value MCDMC31 H700696X;
label value MCDMC42 H700697X;
label value MCDMY02 H700698X;
label value MCDMY02X H700699X;
label value MCDNO02 H700700X;
label value MCDNO02X H700701X;
label value MCDOC02 H700702X;
label value MCDOC02X H700703X;
label value MCDSE02 H700704X;
label value MCDSE02X H700705X;
label value MCRAP02 H700706X;
label value MCRAP02X H700707X;
label value MCRAU02 H700708X;
label value MCRAU02X H700709X;
label value MCRDE02 H700710X;
label value MCRDE02X H700711X;
label value MCREV02 H700712X;
label value MCRFE02 H700713X;
label value MCRFE02X H700714X;
label value MCRJA02 H700715X;
label value MCRJA02X H700716X;
label value MCRJL02 H700717X;
label value MCRJL02X H700718X;
label value MCRJU02 H700719X;
label value MCRJU02X H700720X;
label value MCRMA02 H700721X;
label value MCRMA02X H700722X;
label value MCRMY02 H700723X;
label value MCRMY02X H700724X;
label value MCRNO02 H700725X;
label value MCRNO02X H700726X;
label value MCROC02 H700727X;
label value MCROC02X H700728X;
label value MCRSE02 H700729X;
label value MCRSE02X H700730X;
label value MCS42 H700731X;
label value MDDLAY42 H700732X;
label value MDDLPR42 H700733X;
label value MDDLRS42 H700734X;
label value MDUNAB42 H700735X;
label value MDUNPR42 H700736X;
label value MDUNRS42 H700737X;
label value MESBPR42 H700738X;
label value MESHGT42 H700739X;
label value MESVIS42 H700740X;
label value MESWGT42 H700741X;
label value MIDX53 H700742X;
label value MILDIF31 H700743X;
label value MILDIF53 H700744X;
label value MINORP42 H700745X;
label value MNHLTH31 H700746X;
label value MNHLTH42 H700747X;
label value MNHLTH53 H700748X;
label value MOMPRO42 H700749X;
label value MORE31 H700750X;
label value MORE42 H700751X;
label value MORE53 H700752X;
label value MORECOVR H700753X;
label value MORJOB31 H700754X;
label value MORJOB42 H700755X;
label value MORJOB53 H700756X;
label value MSA02 H700757X;
label value MSA31 H700758X;
label value MSA42 H700759X;
label value MSA53 H700760X;
label value MYSELF42 H700761X;
label value NATAMP42 H700762X;
label value NERVAF42 H700763X;
label value NEVILL42 H700764X;
label value NEWARE42 H700765X;
label value NEWDOC42 H700766X;
label value NOASPR53 H700767X;
label value NOFAT53 H700768X;
label value NOGODR42 H700769X;
label value NOINSBEF H700770X;
label value NOINSTM H700771X;
label value NOINUNIT H700772X;
label value NOLIKE42 H700773X;
label value NOREAS42 H700774X;
label value NOSMOK42 H700775X;
label value NUMEMP31 H700776X;
label value NUMEMP42 H700777X;
label value NUMEMP53 H700778X;
label value NWK31 H700779X;
label value NWK42 H700780X;
label value NWK53 H700781X;
label value OBAEXP02 H700782X;
label value OBAMCD02 H700783X;
label value OBAMCR02 H700784X;
label value OBAOFD02 H700785X;
label value OBAOPR02 H700786X;
label value OBAOPU02 H700787X;
label value OBAOSR02 H700788X;
label value OBAPRV02 H700789X;
label value OBASLF02 H700790X;
label value OBASST02 H700791X;
label value OBASTL02 H700792X;
label value OBATCH02 H700793X;
label value OBATRI02 H700794X;
label value OBAVA02 H700795X;
label value OBAWCP02 H700796X;
label value OBCEXP02 H700797X;
label value OBCHIR02 H700798X;
label value OBCMCD02 H700799X;
label value OBCMCR02 H700800X;
label value OBCOFD02 H700801X;
label value OBCOPR02 H700802X;
label value OBCOPU02 H700803X;
label value OBCOSR02 H700804X;
label value OBCPRV02 H700805X;
label value OBCSLF02 H700806X;
label value OBCSTL02 H700807X;
label value OBCTCH02 H700808X;
label value OBCTRI02 H700809X;
label value OBCVA02 H700810X;
label value OBCWCP02 H700811X;
label value OBDEXP02 H700812X;
label value OBDMCD02 H700813X;
label value OBDMCR02 H700814X;
label value OBDOFD02 H700815X;
label value OBDOPR02 H700816X;
label value OBDOPU02 H700817X;
label value OBDOSR02 H700818X;
label value OBDPRV02 H700819X;
label value OBDRV02 H700820X;
label value OBDSLF02 H700821X;
label value OBDSTL02 H700822X;
label value OBDTCH02 H700823X;
label value OBDTRI02 H700824X;
label value OBDVA02 H700825X;
label value OBDWCP02 H700826X;
label value OBEEXP02 H700827X;
label value OBEMCD02 H700828X;
label value OBEMCR02 H700829X;
label value OBEOFD02 H700830X;
label value OBEOPR02 H700831X;
label value OBEOPU02 H700832X;
label value OBEOSR02 H700833X;
label value OBEPRV02 H700834X;
label value OBESLF02 H700835X;
label value OBESTL02 H700836X;
label value OBETCH02 H700837X;
label value OBETRI02 H700838X;
label value OBEVA02 H700839X;
label value OBEWCP02 H700840X;
label value OBNEXP02 H700841X;
label value OBNMCD02 H700842X;
label value OBNMCR02 H700843X;
label value OBNOFD02 H700844X;
label value OBNOPR02 H700845X;
label value OBNOPU02 H700846X;
label value OBNOSR02 H700847X;
label value OBNPRV02 H700848X;
label value OBNSLF02 H700849X;
label value OBNSTL02 H700850X;
label value OBNTCH02 H700851X;
label value OBNTRI02 H700852X;
label value OBNURS02 H700853X;
label value OBNVA02 H700854X;
label value OBNWCP02 H700855X;
label value OBOEXP02 H700856X;
label value OBOMCD02 H700857X;
label value OBOMCR02 H700858X;
label value OBOOFD02 H700859X;
label value OBOOPR02 H700860X;
label value OBOOPU02 H700861X;
label value OBOOSR02 H700862X;
label value OBOPRV02 H700863X;
label value OBOPTO02 H700864X;
label value OBOSLF02 H700865X;
label value OBOSTL02 H700866X;
label value OBOTCH02 H700867X;
label value OBOTHV02 H700868X;
label value OBOTRI02 H700869X;
label value OBOVA02 H700870X;
label value OBOWCP02 H700871X;
label value OBTEXP02 H700872X;
label value OBTHER02 H700873X;
label value OBTMCD02 H700874X;
label value OBTMCR02 H700875X;
label value OBTOFD02 H700876X;
label value OBTOPR02 H700877X;
label value OBTOPU02 H700878X;
label value OBTOSR02 H700879X;
label value OBTOTV02 H700880X;
label value OBTPRV02 H700881X;
label value OBTSLF02 H700882X;
label value OBTSTL02 H700883X;
label value OBTTCH02 H700884X;
label value OBTTRI02 H700885X;
label value OBTVA02 H700886X;
label value OBTWCP02 H700887X;
label value OBVEXP02 H700888X;
label value OBVMCD02 H700889X;
label value OBVMCR02 H700890X;
label value OBVOFD02 H700891X;
label value OBVOPR02 H700892X;
label value OBVOPU02 H700893X;
label value OBVOSR02 H700894X;
label value OBVPRV02 H700895X;
label value OBVSLF02 H700896X;
label value OBVSTL02 H700897X;
label value OBVTCH02 H700898X;
label value OBVTRI02 H700899X;
label value OBVVA02 H700900X;
label value OBVWCP02 H700901X;
label value OCCCAT31 H700902X;
label value OCCCAT42 H700903X;
label value OCCCAT53 H700904X;
label value OFFER31X H700905X;
label value OFFER42X H700906X;
label value OFFER53X H700907X;
label value OFFHOU42 H700908X;
label value OFREMP31 H700909X;
label value OFREMP42 H700910X;
label value OFREMP53 H700911X;
label value OHRTDX53 H700912X;
label value ONGONG42 H700913X;
label value ONJOB42 H700914X;
label value OPAAP02 H700915X;
label value OPAAU02 H700916X;
label value OPADE02 H700917X;
label value OPAEV02 H700918X;
label value OPAFE02 H700919X;
label value OPAJA02 H700920X;
label value OPAJL02 H700921X;
label value OPAJU02 H700922X;
label value OPAMA02 H700923X;
label value OPAMY02 H700924X;
label value OPANO02 H700925X;
label value OPAOC02 H700926X;
label value OPASE02 H700927X;
label value OPBAP02 H700928X;
label value OPBAU02 H700929X;
label value OPBDE02 H700930X;
label value OPBEV02 H700931X;
label value OPBFE02 H700932X;
label value OPBJA02 H700933X;
label value OPBJL02 H700934X;
label value OPBJU02 H700935X;
label value OPBMA02 H700936X;
label value OPBMY02 H700937X;
label value OPBNO02 H700938X;
label value OPBOC02 H700939X;
label value OPBSE02 H700940X;
label value OPDEXP02 H700941X;
label value OPDMCD02 H700942X;
label value OPDMCR02 H700943X;
label value OPDOFD02 H700944X;
label value OPDOPR02 H700945X;
label value OPDOPU02 H700946X;
label value OPDOSR02 H700947X;
label value OPDPRV02 H700948X;
label value OPDRV02 H700949X;
label value OPDSLF02 H700950X;
label value OPDSTL02 H700951X;
label value OPDTCH02 H700952X;
label value OPDTRI02 H700953X;
label value OPDVA02 H700954X;
label value OPDWCP02 H700955X;
label value OPFEXP02 H700956X;
label value OPFMCD02 H700957X;
label value OPFMCR02 H700958X;
label value OPFOFD02 H700959X;
label value OPFOPR02 H700960X;
label value OPFOPU02 H700961X;
label value OPFOSR02 H700962X;
label value OPFPRV02 H700963X;
label value OPFSLF02 H700964X;
label value OPFSTL02 H700965X;
label value OPFTCH02 H700966X;
label value OPFTRI02 H700967X;
label value OPFVA02 H700968X;
label value OPFWCP02 H700969X;
label value OPOEXP02 H700970X;
label value OPOMCD02 H700971X;
label value OPOMCR02 H700972X;
label value OPOOFD02 H700973X;
label value OPOOPR02 H700974X;
label value OPOOPU02 H700975X;
label value OPOOSR02 H700976X;
label value OPOPRV02 H700977X;
label value OPOSLF02 H700978X;
label value OPOSTL02 H700979X;
label value OPOTCH02 H700980X;
label value OPOTHV02 H700981X;
label value OPOTRI02 H700982X;
label value OPOVA02 H700983X;
label value OPOWCP02 H700984X;
label value OPPEXP02 H700985X;
label value OPPMCD02 H700986X;
label value OPPMCR02 H700987X;
label value OPPOFD02 H700988X;
label value OPPOPR02 H700989X;
label value OPPOPU02 H700990X;
label value OPPOSR02 H700991X;
label value OPPPRV02 H700992X;
label value OPPSLF02 H700993X;
label value OPPSTL02 H700994X;
label value OPPTCH02 H700995X;
label value OPPTRI02 H700996X;
label value OPPVA02 H700997X;
label value OPPWCP02 H700998X;
label value OPSEXP02 H700999X;
label value OPSMCD02 H701000X;
label value OPSMCR02 H701001X;
label value OPSOFD02 H701002X;
label value OPSOPR02 H701003X;
label value OPSOPU02 H701004X;
label value OPSOSR02 H701005X;
label value OPSPRV02 H701006X;
label value OPSSLF02 H701007X;
label value OPSSTL02 H701008X;
label value OPSTCH02 H701009X;
label value OPSTRI02 H701010X;
label value OPSVA02 H701011X;
label value OPSWCP02 H701012X;
label value OPTOTV02 H701013X;
label value OPVEXP02 H701014X;
label value OPVMCD02 H701015X;
label value OPVMCR02 H701016X;
label value OPVOFD02 H701017X;
label value OPVOPR02 H701018X;
label value OPVOPU02 H701019X;
label value OPVOSR02 H701020X;
label value OPVPRV02 H701021X;
label value OPVSLF02 H701022X;
label value OPVSTL02 H701023X;
label value OPVTCH02 H701024X;
label value OPVTRI02 H701025X;
label value OPVVA02 H701026X;
label value OPVWCP02 H701027X;
label value OTHDYS31 H701028X;
label value OTHDYS42 H701029X;
label value OTHDYS53 H701030X;
label value OTHEXP02 H701031X;
label value OTHIMP02 H701032X;
label value OTHINS42 H701033X;
label value OTHMCD02 H701034X;
label value OTHMCR02 H701035X;
label value OTHNDD31 H701036X;
label value OTHNDD42 H701037X;
label value OTHNDD53 H701038X;
label value OTHOFD02 H701039X;
label value OTHOPR02 H701040X;
label value OTHOPU02 H701041X;
label value OTHOSR02 H701042X;
label value OTHPRV02 H701043X;
label value OTHRCP42 H701044X;
label value OTHREA42 H701045X;
label value OTHRP02X H701046X;
label value OTHSLF02 H701047X;
label value OTHSTL02 H701048X;
label value OTHTCH02 H701049X;
label value OTHTRI02 H701050X;
label value OTHVA02 H701051X;
label value OTHWCP02 H701052X;
label value OTPAAT02 H701053X;
label value OTPAAT31 H701054X;
label value OTPAAT42 H701055X;
label value OTPAAT53 H701056X;
label value OTPBAT02 H701057X;
label value OTPBAT31 H701058X;
label value OTPBAT42 H701059X;
label value OTPBAT53 H701060X;
label value OTPUBA02 H701061X;
label value OTPUBA31 H701062X;
label value OTPUBA42 H701063X;
label value OTPUBA53 H701064X;
label value OTPUBB02 H701065X;
label value OTPUBB31 H701066X;
label value OTPUBB42 H701067X;
label value OTPUBB53 H701068X;
label value PACISP42 H701069X;
label value PANEL02 H701070X;
label value PAPSMR53 H701071X;
label value PAYDR31 H701072X;
label value PAYDR42 H701073X;
label value PAYDR53 H701074X;
label value PAYVAC31 H701075X;
label value PAYVAC42 H701076X;
label value PAYVAC53 H701077X;
label value PCS42 H701078X;
label value PDKAP02 H701079X;
label value PDKAU02 H701080X;
label value PDKDE02 H701081X;
label value PDKFE02 H701082X;
label value PDKJA02 H701083X;
label value PDKJL02 H701084X;
label value PDKJU02 H701085X;
label value PDKMA02 H701086X;
label value PDKMY02 H701087X;
label value PDKNO02 H701088X;
label value PDKOC02 H701089X;
label value PDKSE02 H701090X;
label value PEGAP02 H701091X;
label value PEGAU02 H701092X;
label value PEGDE02 H701093X;
label value PEGFE02 H701094X;
label value PEGJA02 H701095X;
label value PEGJL02 H701096X;
label value PEGJU02 H701097X;
label value PEGMA02 H701098X;
label value PEGMY02 H701099X;
label value PEGNO02 H701100X;
label value PEGOC02 H701101X;
label value PEGSE02 H701102X;
label value PENIMP02 H701103X;
label value PENSP02X H701104X;
label value PERSLA42 H701105X;
label value PERWT02F H701106X;
label value PHMONP02 H701107X;
label value PHMONP31 H701108X;
label value PHMONP42 H701109X;
label value PHNREG42 H701110X;
label value PHYACT53 H701111X;
label value PHYSCL42 H701112X;
label value PLCTYP42 H701113X;
label value PMDLAY42 H701114X;
label value PMDLPR42 H701115X;
label value PMDLRS42 H701116X;
label value PMEDIN31 H701117X;
label value PMEDIN42 H701118X;
label value PMEDIN53 H701119X;
label value PMNCNP02 H701120X;
label value PMNCNP31 H701121X;
label value PMNCNP42 H701122X;
label value PMUNAB42 H701123X;
label value PMUNPR42 H701124X;
label value PMUNRS42 H701125X;
label value PNGAP02 H701126X;
label value PNGAU02 H701127X;
label value PNGDE02 H701128X;
label value PNGFE02 H701129X;
label value PNGJA02 H701130X;
label value PNGJL02 H701131X;
label value PNGJU02 H701132X;
label value PNGMA02 H701133X;
label value PNGMY02 H701134X;
label value PNGNO02 H701135X;
label value PNGOC02 H701136X;
label value PNGSE02 H701137X;
label value POGAP02 H701138X;
label value POGAU02 H701139X;
label value POGDE02 H701140X;
label value POGFE02 H701141X;
label value POGJA02 H701142X;
label value POGJL02 H701143X;
label value POGJU02 H701144X;
label value POGMA02 H701145X;
label value POGMY02 H701146X;
label value POGNO02 H701147X;
label value POGOC02 H701148X;
label value POGSE02 H701149X;
label value POUAP02 H701150X;
label value POUAU02 H701151X;
label value POUDE02 H701152X;
label value POUFE02 H701153X;
label value POUJA02 H701154X;
label value POUJL02 H701155X;
label value POUJU02 H701156X;
label value POUMA02 H701157X;
label value POUMY02 H701158X;
label value POUNO02 H701159X;
label value POUOC02 H701160X;
label value POUSE02 H701161X;
label value POVCAT02 H701162X;
label value PPRWRKM H701163X;
label value PPRWRKT H701164X;
label value PRBINFOM H701165X;
label value PRBINFOT H701166X;
label value PRBPWKM H701167X;
label value PRBPWKT H701168X;
label value PRBSVCM H701169X;
label value PRBSVCT H701170X;
label value PRDRNP02 H701171X;
label value PRDRNP31 H701172X;
label value PRDRNP42 H701173X;
label value PREVCOVR H701174X;
label value PREVEN42 H701175X;
label value PRIAP02 H701176X;
label value PRIAU02 H701177X;
label value PRIDE02 H701178X;
label value PRIDK02 H701179X;
label value PRIDK31 H701180X;
label value PRIDK42 H701181X;
label value PRIDK53 H701182X;
label value PRIEU02 H701183X;
label value PRIEU31 H701184X;
label value PRIEU42 H701185X;
label value PRIEU53 H701186X;
label value PRIFE02 H701187X;
label value PRIJA02 H701188X;
label value PRIJL02 H701189X;
label value PRIJU02 H701190X;
label value PRIMA02 H701191X;
label value PRIMY02 H701192X;
label value PRING02 H701193X;
label value PRING31 H701194X;
label value PRING42 H701195X;
label value PRING53 H701196X;
label value PRINO02 H701197X;
label value PRIOC02 H701198X;
label value PRIOG02 H701199X;
label value PRIOG31 H701200X;
label value PRIOG42 H701201X;
label value PRIOG53 H701202X;
label value PRIS02 H701203X;
label value PRIS31 H701204X;
label value PRIS42 H701205X;
label value PRIS53 H701206X;
label value PRISE02 H701207X;
label value PRIV02 H701208X;
label value PRIV31 H701209X;
label value PRIV42 H701210X;
label value PRIV53 H701211X;
label value PRIVAT02 H701212X;
label value PRIVAT31 H701213X;
label value PRIVAT42 H701214X;
label value PRIVAT53 H701215X;
label value PROUT02 H701216X;
label value PROUT31 H701217X;
label value PROUT42 H701218X;
label value PROUT53 H701219X;
label value PROVTY42 H701220X;
label value PROXY02 H701221X;
label value PROXY31 H701222X;
label value PROXY42 H701223X;
label value PROXY53 H701224X;
label value PRSAP02 H701225X;
label value PRSAU02 H701226X;
label value PRSDE02 H701227X;
label value PRSFE02 H701228X;
label value PRSJA02 H701229X;
label value PRSJL02 H701230X;
label value PRSJU02 H701231X;
label value PRSMA02 H701232X;
label value PRSMY02 H701233X;
label value PRSNO02 H701234X;
label value PRSOC02 H701235X;
label value PRSSE02 H701236X;
label value PRVDRL02 H701237X;
label value PRVDRL31 H701238X;
label value PRVDRL42 H701239X;
label value PRVEV02 H701240X;
label value PRVHMO02 H701241X;
label value PRVHMO31 H701242X;
label value PRVHMO42 H701243X;
label value PRVMNC02 H701244X;
label value PRVMNC31 H701245X;
label value PRVMNC42 H701246X;
label value PSA53 H701247X;
label value PSTATS31 H701248X;
label value PSTATS42 H701249X;
label value PSTATS53 H701250X;
label value PUB02X H701251X;
label value PUB31X H701252X;
label value PUB42X H701253X;
label value PUB53X H701254X;
label value PUBAP02X H701255X;
label value PUBAT02X H701256X;
label value PUBAT31X H701257X;
label value PUBAT42X H701258X;
label value PUBAT53X H701259X;
label value PUBAU02X H701260X;
label value PUBDE02X H701261X;
label value PUBFE02X H701262X;
label value PUBIMP02 H701263X;
label value PUBJA02X H701264X;
label value PUBJL02X H701265X;
label value PUBJU02X H701266X;
label value PUBMA02X H701267X;
label value PUBMY02X H701268X;
label value PUBNO02X H701269X;
label value PUBOC02X H701270X;
label value PUBP02X H701271X;
label value PUBSE02X H701272X;
label value RACEAX H701273X;
label value RACEBX H701274X;
label value RACETHNX H701275X;
label value RACEWX H701276X;
label value RACEX H701277X;
label value RATPLANM H701278X;
label value RATPLANT H701279X;
label value RCHDIF31 H701280X;
label value RCHDIF53 H701281X;
label value READNW42 H701282X;
label value RECPEP42 H701283X;
label value REFDP02X H701284X;
label value REFFRL42 H701285X;
label value REFIMP02 H701286X;
label value REGION02 H701287X;
label value REGION31 H701288X;
label value REGION42 H701289X;
label value REGION53 H701290X;
label value RESP02 H701291X;
label value RESP31 H701292X;
label value RESP42 H701293X;
label value RESP53 H701294X;
label value RESPCT42 H701295X;
label value RETPLN31 H701296X;
label value RETPLN42 H701297X;
label value RETPLN53 H701298X;
label value RFREL02X H701299X;
label value RFREL31X H701300X;
label value RFREL42X H701301X;
label value RFREL53X H701302X;
label value RNDFLG31 H701303X;
label value RTHLTH31 H701304X;
label value RTHLTH42 H701305X;
label value RTHLTH53 H701306X;
label value RUCLAS02 H701307X;
label value RUCLAS31 H701308X;
label value RUCLAS42 H701309X;
label value RUCLAS53 H701310X;
label value RUSIZE02 H701311X;
label value RUSIZE31 H701312X;
label value RUSIZE42 H701313X;
label value RUSIZE53 H701314X;
label value RXEXP02 H701315X;
label value RXMCD02 H701316X;
label value RXMCR02 H701317X;
label value RXOFD02 H701318X;
label value RXOPR02 H701319X;
label value RXOPU02 H701320X;
label value RXOSR02 H701321X;
label value RXPRV02 H701322X;
label value RXSLF02 H701323X;
label value RXSTL02 H701324X;
label value RXTOT02 H701325X;
label value RXTRI02 H701326X;
label value RXVA02 H701327X;
label value RXWCP02 H701328X;
label value SAFEST42 H701329X;
label value SALEP02X H701330X;
label value SALIMP02 H701331X;
label value SAQELIG H701332X;
label value SCHLBH42 H701333X;
label value SCHLIM31 H701334X;
label value SCHLIM53 H701335X;
label value SCHPRO42 H701336X;
label value SCLNBD31 H701337X;
label value SCLNBD42 H701338X;
label value SCLNBD53 H701339X;
label value SEATBE53 H701340X;
label value SEEDIF42 H701341X;
label value SELDSI42 H701342X;
label value SELFCM31 H701343X;
label value SELFCM42 H701344X;
label value SELFCM53 H701345X;
label value SEX H701346X;
label value SFFLAG42 H701347X;
label value SIBPRO42 H701348X;
label value SICEAS42 H701349X;
label value SICPAY31 H701350X;
label value SICPAY42 H701351X;
label value SICPAY53 H701352X;
label value SOCLIM31 H701353X;
label value SOCLIM53 H701354X;
label value SPOUID02 H701355X;
label value SPOUID31 H701356X;
label value SPOUID42 H701357X;
label value SPOUID53 H701358X;
label value SPOUIN02 H701359X;
label value SPOUIN31 H701360X;
label value SPOUIN42 H701361X;
label value SPOUIN53 H701362X;
label value SPRPRO42 H701363X;
label value SRTHRT53 H701364X;
label value SSCIMP02 H701365X;
label value SSECP02X H701366X;
label value SSIDIS02 H701367X;
label value SSIIMP02 H701368X;
label value SSIP02X H701369X;
label value SSNLJB31 H701370X;
label value SSNLJB42 H701371X;
label value SSNLJB53 H701372X;
label value STAAP02 H701373X;
label value STAAU02 H701374X;
label value STADE02 H701375X;
label value STAFE02 H701376X;
label value STAJA02 H701377X;
label value STAJL02 H701378X;
label value STAJU02 H701379X;
label value STAMA02 H701380X;
label value STAMY02 H701381X;
label value STANO02 H701382X;
label value STAOC02 H701383X;
label value STAPR02 H701384X;
label value STAPR31 H701385X;
label value STAPR42 H701386X;
label value STAPR53 H701387X;
label value STASE02 H701388X;
label value STJBDD31 H701389X;
label value STJBDD42 H701390X;
label value STJBDD53 H701391X;
label value STJBMM31 H701392X;
label value STJBMM42 H701393X;
label value STJBMM53 H701394X;
label value STJBYY31 H701395X;
label value STJBYY42 H701396X;
label value STJBYY53 H701397X;
label value STNDIF31 H701398X;
label value STNDIF53 H701399X;
label value STOMCH53 H701400X;
label value STOOL53 H701401X;
label value STPDIF31 H701402X;
label value STPDIF53 H701403X;
label value STPRAT02 H701404X;
label value STPRAT31 H701405X;
label value STPRAT42 H701406X;
label value STPRAT53 H701407X;
label value STRKDX53 H701408X;
label value TAXFRM02 H701409X;
label value TEMPJB31 H701410X;
label value TEMPJB42 H701411X;
label value TEMPJB53 H701412X;
label value THANTB53 H701413X;
label value THANTF53 H701414X;
label value THSWAB53 H701415X;
label value THSWBF53 H701416X;
label value THSYMF53 H701417X;
label value THSYMP53 H701418X;
label value TIMALN42 H701419X;
label value TMTKUS42 H701420X;
label value TOTDED02 H701421X;
label value TOTEXP02 H701422X;
label value TOTMCD02 H701423X;
label value TOTMCR02 H701424X;
label value TOTOFD02 H701425X;
label value TOTOPR02 H701426X;
label value TOTOPU02 H701427X;
label value TOTOSR02 H701428X;
label value TOTPRV02 H701429X;
label value TOTSLF02 H701430X;
label value TOTSTL02 H701431X;
label value TOTTCH02 H701432X;
label value TOTTRI02 H701433X;
label value TOTVA02 H701434X;
label value TOTWCP02 H701435X;
label value TRBLE42 H701436X;
label value TREATM42 H701437X;
label value TRIAP02X H701438X;
label value TRIAT02X H701439X;
label value TRIAT31X H701440X;
label value TRIAT42X H701441X;
label value TRIAT53X H701442X;
label value TRIAU02X H701443X;
label value TRICR02X H701444X;
label value TRICR31X H701445X;
label value TRICR42X H701446X;
label value TRICR53X H701447X;
label value TRIDE02X H701448X;
label value TRIEV02 H701449X;
label value TRIEX02X H701450X;
label value TRIEX31X H701451X;
label value TRIEX42X H701452X;
label value TRIFE02X H701453X;
label value TRIJA02X H701454X;
label value TRIJL02X H701455X;
label value TRIJU02X H701456X;
label value TRILI02X H701457X;
label value TRILI42X H701458X;
label value TRIMA02X H701459X;
label value TRIMY02X H701460X;
label value TRINO02X H701461X;
label value TRIOC02X H701462X;
label value TRIPR02X H701463X;
label value TRIPR31X H701464X;
label value TRIPR42X H701465X;
label value TRISE02X H701466X;
label value TRIST02X H701467X;
label value TRIST31X H701468X;
label value TRIST42X H701469X;
label value TRSTP02X H701470X;
label value TRTIMP02 H701471X;
label value TTLP02X H701472X;
label value TYPEPE42 H701473X;
label value UNABLE31 H701474X;
label value UNABLE53 H701475X;
label value UNEIMP02 H701476X;
label value UNEMP02X H701477X;
label value UNHAP42 H701478X;
label value UNINS02 H701479X;
label value UNION31 H701480X;
label value UNION42 H701481X;
label value UNION53 H701482X;
label value USBORN42 H701483X;
label value USCNOT42 H701484X;
label value USLGLV42 H701485X;
label value VETGULF H701486X;
label value VETIMP02 H701487X;
label value VETKOR H701488X;
label value VETOTH H701489X;
label value VETSP02X H701490X;
label value VETVIET H701491X;
label value VETWW H701492X;
label value VISEXP02 H701493X;
label value VISION42 H701494X;
label value VISMCD02 H701495X;
label value VISMCR02 H701496X;
label value VISOFD02 H701497X;
label value VISOPR02 H701498X;
label value VISOPU02 H701499X;
label value VISOSR02 H701500X;
label value VISPRV02 H701501X;
label value VISSLF02 H701502X;
label value VISSTL02 H701503X;
label value VISTCH02 H701504X;
label value VISTRI02 H701505X;
label value VISVA02 H701506X;
label value VISWCP02 H701507X;
label value WAGEP02X H701508X;
label value WAGIMP02 H701509X;
label value WASAFDC H701510X;
label value WASCHAMP H701511X;
label value WASESTB H701512X;
label value WASMCAID H701513X;
label value WASMCARE H701514X;
label value WASOTGOV H701515X;
label value WASOTHER H701516X;
label value WASPRIV H701517X;
label value WASSSI H701518X;
label value WASSTAT1 H701519X;
label value WASSTAT2 H701520X;
label value WASSTAT3 H701521X;
label value WASVA H701522X;
label value WCMPP02X H701523X;
label value WCPIMP02 H701524X;
label value WHENST53 H701525X;
label value WHITPR42 H701526X;
label value WHNBPR42 H701527X;
label value WHNBST42 H701528X;
label value WHNBWL53 H701529X;
label value WHNDEN42 H701530X;
label value WHNEAT42 H701531X;
label value WHNHEL42 H701532X;
label value WHNHGT42 H701533X;
label value WHNLAP42 H701534X;
label value WHNPHY42 H701535X;
label value WHNSAF42 H701536X;
label value WHNSMK42 H701537X;
label value WHNWGT42 H701538X;
label value WILFIL02 H701539X;
label value WKINBD31 H701540X;
label value WKINBD42 H701541X;
label value WKINBD53 H701542X;
label value WLK3MO31 H701543X;
label value WLK3MO53 H701544X;
label value WLKDIF31 H701545X;
label value WLKDIF53 H701546X;
label value WLKLIM31 H701547X;
label value WLKLIM53 H701548X;
label value WRGLAS42 H701549X;
label value WRHLTH42 H701550X;
label value WRKLIM31 H701551X;
label value WRKLIM53 H701552X;
label value YCHJ3142 H701553X;
label value YCHJ4253 H701554X;
label value YNOINS31 H701555X;
label value YNOINS42 H701556X;
label value YNOINS53 H701557X;
label value YNOUSC42 H701558X;
label value ZIDEXP02 H701559X;
label value ZIDMCD02 H701560X;
label value ZIDMCR02 H701561X;
label value ZIDOFD02 H701562X;
label value ZIDOPR02 H701563X;
label value ZIDOPU02 H701564X;
label value ZIDOSR02 H701565X;
label value ZIDPRV02 H701566X;
label value ZIDSLF02 H701567X;
label value ZIDSTL02 H701568X;
label value ZIDTCH02 H701569X;
label value ZIDTRI02 H701570X;
label value ZIDVA02 H701571X;
label value ZIDWCP02 H701572X;
label value ZIFEXP02 H701573X;
label value ZIFMCD02 H701574X;
label value ZIFMCR02 H701575X;
label value ZIFOFD02 H701576X;
label value ZIFOPR02 H701577X;
label value ZIFOPU02 H701578X;
label value ZIFOSR02 H701579X;
label value ZIFPRV02 H701580X;
label value ZIFSLF02 H701581X;
label value ZIFSTL02 H701582X;
label value ZIFTCH02 H701583X;
label value ZIFTRI02 H701584X;
label value ZIFVA02 H701585X;
label value ZIFWCP02 H701586X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr

/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H70.LOG and a data file named H70.DTA.  If these files (H70.DTA and H70.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

